<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_518a2 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], 'package', 1, 1));
		$db = vB::getDbAssertor();
		$package = $db->getRow('package', array('class' => 'vBBlog'));
		if (!$package)
		{
			//we need this for the legacy but there is no longer a blog product.
			$result = $db->insert('package', array(
				'productid' => 'vbulletin',
				'class' => 'vBBlog'
			));
		}
		else
		{
			if ($package['productid'] != 'vbulletin')
			{
				$db->update('package', array('productid' => 'vbulletin'), array('packageid' => $package['packageid']));
			}
		}
	}

	public function step_2()
	{
		$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], 'contenttype', 1, 2));

		//legacy type information for the mobile API
		$db = vB::getDbAssertor();
		$contenttype = $db->getRow('vBForum:contenttype', array('class' => 'BlogEntry'));
		if (!$contenttype)
		{

			//we should have verified that this exists in step1
			$package = $db->getRow('package', array('class' => 'vBBlog'));

			$db->insert('vBForum:contenttype', array(
				'class' => 'BlogEntry',
				'packageid' => $package['packageid'],
				'canplace' => '0',
				'cansearch' => '0',
				'cantag' => '0',
				'canattach' => '1',
				'isaggregator' => '0'
			));
		}
	}


	public function step_3()
	{
		$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], 'contenttype', 2, 2));

		//legacy type information for the mobile API
		$db = vB::getDbAssertor();
		$contenttype = $db->getRow('vBForum:contenttype', array('class' => 'BlogComment'));
		if (!$contenttype)
		{
			//we should have verified that this exists in step1
			$package = $db->getRow('package', array('class' => 'vBBlog'));

			$db->insert('vBForum:contenttype', array(
				'class' => 'BlogComment',
				'packageid' => $package['packageid'],
				'canplace' => '0',
				'cansearch' => '0',
				'cantag' => '0',
				'canattach' => '1',
				'isaggregator' => '0'
			));
		}
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112203 $
|| ####################################################################
\*======================================================================*/
