<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_515a5 extends vB_Upgrade_Version
{
	/**
	 * Turn the user mention notification option on for new registrations by default
	 */
	public function step_1()
	{
		// Add 268435456 (general_usermention) to the default value for notification_options
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'user', 1, 2),
			"ALTER TABLE " . TABLE_PREFIX . "user
			CHANGE notification_options notification_options INT UNSIGNED NOT NULL DEFAULT '536870906'"
		);
	}

	/**
	 * Turn the user mention notification option on for all current users by default
	 */
	public function step_2()
	{
		// Turn 268435456 on (general_usermention) for all users
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'user', 2, 2),
			"UPDATE " . TABLE_PREFIX . "user
			SET notification_options = (notification_options | 268435456)"
		);
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112178 $
|| #######################################################################
\*=========================================================================*/
