<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_513a1 extends vB_Upgrade_Version
{
	public function step_1()
	{
		if ($this->tableExists('album'))
		{
			$Types = vB_Types::instance();
			$albumType = $Types->getContentTypeID('vBForum_Album');
			$galleryType = $Types->getContentTypeID('vBForum_Gallery');
			$photoType = $Types->getContentTypeID('vBForum_Photo');

			$this->show_message(sprintf($this->phrase['version']['513a1']['setting_private_albums_from_4'], 'forum'));
			vB::getDbAssertor()->assertQuery('vBInstall:setPrivateAlbums', array('albumtype' => $albumType, 'gallerytype' => $galleryType, 'phototype' => $photoType));
		}
		else
		{
			$this->skip_message();
		}
	}

	public function step_2()
	{
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'hook', 1, 1),
			"ALTER TABLE " . TABLE_PREFIX . "hook MODIFY COLUMN hookname  varchar(100)"
		);
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112178 $
|| #######################################################################
\*=========================================================================*/
