<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_511a9 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'rssfeed', 1, 1),
			"ALTER TABLE " . TABLE_PREFIX . "rssfeed MODIFY COLUMN nodeid INT UNSIGNED NOT NULL DEFAULT '0'"
		);
	}

	public function step_2()
	{
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'moderator', 1, 1),
			"ALTER TABLE " . TABLE_PREFIX . "moderator MODIFY COLUMN nodeid INT NOT NULL DEFAULT '0'"
		);
	}

	/**
	 * Add the usergroup.forumpermissions2 column
	 */
	public function step_3()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'usergroup', 1, 1),
			'usergroup',
			'forumpermissions2',
			'int',
			self::FIELD_DEFAULTS
		);
	}

	/**
	 * Make sure the bitfields are up-to-date (for next step)
	 */
	public function step_4()
	{
		vB_Upgrade::createAdminSession();
		require_once(DIR . '/includes/class_bitfield_builder.php');
		vB_Bitfield_Builder::save();
		$this->show_message(sprintf($this->phrase['core']['rebuild_x_datastore'], 'bitfields'));
	}

	/**
	 * Ensure that the new 'cangetimgattachment' setting matches the
	 * value of 'cangetattachment' for all usergroups (this was done
	 * for permission records in the 511a5 upgrade)
	 */
	public function step_5()
	{
		// Get the bitfields
		$forumpermissions = vB::getDatastore()->getValue('bf_ugp_forumpermissions');
		$forumpermissions2 = vB::getDatastore()->getValue('bf_ugp_forumpermissions2');

		// Set the new 'cangetimageattachment' permission.
		// Everyone who has the 'cangetattachment' permission gets this
		// new one when upgrading.
		$this->run_query(
			sprintf($this->phrase['vbphrase']['update_table_x'], TABLE_PREFIX . 'usergroup', 1, 2),
			"
				UPDATE " . TABLE_PREFIX . "usergroup
				SET forumpermissions2 = forumpermissions2 | " . intval($forumpermissions2['cangetimgattachment']) . "
				WHERE forumpermissions & " . intval($forumpermissions['cangetattachment']) . "
			"
		);
	}

	public function step_6()
	{
		$db = vB::getDbAssertor();

		$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], TABLE_PREFIX . 'usergroup', 2, 2));

		$groupinfo = $this->getDefaultGroupPerms();
		foreach($groupinfo AS $id => $perms)
		{
			//so the defaults in the bitfields are messed up for groups that aren't the
			//original eight that we've always had (not only do we not have them set we
			//can't rely on the usergroupid to be same across installs.
			//The added groups should already have the correct privs so skip them
			if ($id > 8)
			{
				continue;
			}

			$db->update('usergroup', array('forumpermissions2' => $perms['forumpermissions2']), array('usergroupid' => $id));
		}
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112203 $
|| #######################################################################
\*=========================================================================*/
