<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_510a7 extends vB_Upgrade_Version
{
	/*
	 *	Step 1 :
	 *	There are 3 possibly dupe page records inserted by 500a1 step_23.
	 * 	The first of these is causing problems, so let's delete it.
	 *	upgrade final's step_8 should fix the route record
	 */
	public function step_1()
	{
		$possibleDupes = array(
			array("pageid" => 1, "parentid" => 0, "routeid" => 9, "guid" => "vbulletin-4ecbdac82ef5d4.12817784"),
			//array("pageid" => 2, "parentid" => 0, "routeid" => 24, "guid" => "vbulletin-52b4c3c6590572.75515897"),
			//array("pageid" => 3, "parentid" => 30, "routeid" => 30, "guid" => "vbulletin-52b4c3c65906c1.50869326"),
		);

		$this->show_message($this->phrase['version']['510a7']['removing_duplicate_page']);

		$importChannels = false;
		foreach($possibleDupes AS $page)
		{
			$dupes = vB::getDbAssertor()->getRows('vBForum:page',
				array(
					'guid' => $page['guid'],
				)
			);

			if (count($dupes) > 1)
			{
				vB::getDbAssertor()->assertQuery('vBForum:page',
					array(
						vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_DELETE,
						'pageid' => $page['pageid'],
						'parentid' => $page['parentid'],
						'routeid' => $page['routeid'],
						'guid' => $page['guid'],
					)
				);
				$importChannels = true;
			}
		}

		$this->final_load_routes();
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
