<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_510a6 extends vB_Upgrade_Version
{
	/**Set the moderatepublish flag for article channel */
	public function step_1()
	{
		// we should only run this once.  If completed this will show as step = 0 because it's the last.
		$check = vB::getDbAssertor()->assertQuery('vBInstall:upgradelog', array('script' => '510a6'));

		if ($check->valid())
		{
			$this->skip_message();
		}
		else
		{
			$this->show_message(sprintf($this->phrase['version']['510a6']['updating_article_options']));
			$parsedRaw = vB_Xml_Import::parseFile(DIR . '/includes/xml/bitfield_vbulletin.xml');
			foreach ($parsedRaw['bitfielddefs']['group'] AS $group)
			{
				if ($group['name'] == 'misc')
				{
					foreach($group['group'] AS $bfgroup)
					{
						if (($bfgroup['name'] == 'forumoptions'))
						{
							$optBits = array();
							foreach ($bfgroup['bitfield'] AS $bitfield)
							{
								if ($bitfield['name'] == 'moderatepublish')
								{
									$modPublish = $bitfield['value'];
									break;
								}
							}
						}
					}
				}
			}
			$articleChannel = vB_Library::instance('content_channel')->fetchChannelByGUID(vB_Channel::DEFAULT_ARTICLE_PARENT);
			vB::getDbAssertor()->assertQuery('vBInstall:updateChannelOptions', array('nodeids' => $articleChannel['nodeid'], 'setOption' => $modPublish));
		}
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112178 $
|| #######################################################################
\*=========================================================================*/
