<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_505a4 extends vB_Upgrade_Version
{
	/**
	 * Set systemgroupid for those groups
	 * Needed here due beta maintenance, we don't want to rerun old upgraders for this
	 */
	public function step_1()
	{
		$this->show_message(sprintf($this->phrase['core']['altering_x_table'], 'widegetinstance', 1, 1));
		vB::getDbAssertor()->assertQuery('vBInstall:makeWidgetInstanceConfUtf8');
	}

	/*
	 *	Step 2 - Make sure old pages have GUID
	 */
	public function step_2()
	{
		$this->show_message(sprintf($this->phrase['version']['505a4']['fix_page_guid']));

		$assertor = vB::getDbAssertor();
		$pages = $assertor->getRows('getPagesWithoutGUID');

		foreach ($pages as $page)
		{
			$assertor->update('page', array('guid' => vB_GUID::get()), array('pageid' => $page['pageid']));
		}

		$this->show_message(sprintf($this->phrase['core']['process_done']));
	}

	/**
	 * Scan and fix filedata refcount
	 */
	public function step_3($data = null)
	{
		$batchsize = 1000;

		$assertor = vB::getDbAssertor();
		$startat = intval($data['startat'] ?? 0);
		$nextid = $assertor->getRow('vBInstall:getNextZeroRefcount', array('startat' => $startat));

		// Check if any users have custom folders
		if (empty($nextid) OR !empty($nextid['errors']) OR empty($nextid['filedataid']))
		{
			if (empty($startat))
			{
				$this->skip_message();
				return;
			}
			$this->show_message(sprintf($this->phrase['core']['process_done']));
			return;
		}

		if (empty($startat))
		{
			$this->show_message($this->phrase['version']['505a4']['fix_filedata_refcount']);
		}

		$startat = $nextid['filedataid'];
		// Get the users for import
		$this->show_message(sprintf($this->phrase['core']['processing_records_x'], $batchsize));
		$assertor->assertQuery('vbinstall:fixRefCount', array('startat' => $startat, 'batchsize' => $batchsize));
		return array('startat' => ($startat + $batchsize), 'maxid' => $maxid);
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
