<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_505a2 extends vB_Upgrade_Version
{
	/**
	 * populating tagnode table based on tagcontent table
	 */
	public function step_1()
	{
		if ($this->tableExists('tagcontent'))
		{
			$log = vB::getDbAssertor()->getRow('vBInstall:upgradelog', array('script' => $this->SHORT_VERSION, 'step' => 1)); // Must match this step.

			if (empty($log))
			{
				$this->show_message($this->phrase['version']['505a2']['importing_tags']);
				vB::getDbAssertor()->assertQuery('vBInstall:importTagContent');
				$this->show_message(sprintf($this->phrase['core']['import_done']));
			}
			else
			{
				$this->skip_message();
			}
		}
		else
		{
			$this->skip_message();
		}
	}

	/**
	 * populating the taglist field in the node table
	 */
	public function step_2()
	{
		$log = vB::getDbAssertor()->getRow('vBInstall:upgradelog', array('script' => $this->SHORT_VERSION, 'step' => 2)); // Must match this step.

		if (empty($log))
		{
			$this->show_message($this->phrase['version']['505a2']['updating_node_tags']);
			vB::getDbAssertor()->assertQuery('vBInstall:updateNodeTags');
			$this->show_message(sprintf($this->phrase['core']['process_done']));
		}
		else
		{
			$this->skip_message();
		}
	}


	/**
	 * Change old page meta phrases from GLOBAL group to pagemeta group
	 */
	public function step_3()
	{
		$this->show_message($this->phrase['version']['505a2']['moving_page_metadata_phrases']);
		vB::getDbAssertor()->assertQuery('vbinstall:movePageMetadataPhrases');
		$this->show_message('done');

		// We don't need to rebuild language as it will be rebuilt in final upgrades
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112179 $
|| #######################################################################
\*=========================================================================*/
