<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_502b1 extends vB_Upgrade_Version
{
	/**
	 * Step 1 - Add Google Checkout
	 */
	public function step_1()
	{
		// This step used to add google checkout paymentapi (paymentapi.classname = 'google'), but google checkout has long since been
		// discontinued and we've removed it. Skipping this.
		$this->skip_message();
	}

	/**
	* Remove any volatile phrases
	*/
	public function step_2()
	{
		$assertor = vB::getDbAssertor();
		$assertor->delete('vBForum:faq', array('volatile' => 1));

		//if any non-volatile faq names have been left orphaned by the delete, promote them to top level.  This will
		//likely require the admin to do some cleanup, but it means his articles won't randomly disappear.  Any structure
		//between nonvolatile articles will be preserved.
		$faq = $assertor->getColumn('vBForum:faq', 'faqname');
		if (count($faq))
		{
			$assertor->update('vBForum:faq', array('faqparent' => 'faqroot'),
				array(array('field' => 'faqparent', 'value' => $faq, 'operator' => vB_dB_Query::OPERATOR_NE))
			);
		}
		$this->show_message($this->phrase['version']['502b1']['removing_faq_entries']);
	}

	public function step_3()
	{
		$schema = $this->load_schema();

		// insert the updated FAQ Structure
		$this->run_query (
			$this->phrase['version']['502b1']['updating_faq_entries'],
			$schema['INSERT']['query']['faq']
		);
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112183 $
|| #######################################################################
\*=========================================================================*/
