<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_501rc1 extends vB_Upgrade_Version
{
	/**
	 * Remove invalid profile routes
	 *
	 */
	public function step_1()
	{
		$this->show_message(sprintf($this->phrase['core']['altering_x_table'], 'routenew', 1, 1));

		// we changed class to vB5_Route_Content at some point in upgrade so let's get rid of them.
		vB::getDbAssertor()->assertQuery('routenew', array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_DELETE,
			vB_dB_Query::CONDITIONS_KEY => array(
				array('field' => 'class', 'value' => 'vB5_Route_Content', 'operator' => vB_dB_Query::OPERATOR_EQ),
				array('field' => 'name', 'value' => array('profile', 'following', 'followers', 'groups', 'settings'), 'operator' => vB_dB_Query::OPERATOR_EQ)
			)
		));

		// we fix settings route class during the upgrade but we have a wrong regex for the duplicate.
		vB::getDbAssertor()->assertQuery('routenew', array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_DELETE,
			vB_dB_Query::CONDITIONS_KEY => array(
				array('field' => 'name', 'value' => 'settings', 'operator' => vB_dB_Query::OPERATOR_EQ),
				array('field' => 'regex', 'value' => 'settings', 'operator' => vB_dB_Query::OPERATOR_EQ)
			)
		));
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
