<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_500b9 extends vB_Upgrade_Version
{
	/** We have some data elements with missing closure records. Let's repair them.
	 *
	 */
	public function step_1($data = array())
	{
		if ($this->tableExists('blog'))
		{
			$repairTypes = array(1 => vB_Types::instance()->getContentTypeID('vBForum_Album'), 2 => 9984, 3 => 9011,
				4 => 9986, 5=> 9990);

			if (isset($data['startat']))
			{
				$startat = $data['startat'];
			}
			else
			{
				$startat = 1;
			}
			$this->show_message(sprintf($this->phrase['version']['500b9']['fixing_closure_records_step_x'], $startat));
			$assertor = vB::getDbAssertor();
			$nodeids = array();
			$nodeQry = $assertor->assertQuery('vBInstall:missingClosureByType', array('oldcontenttypeid' =>$repairTypes[$startat],
				'batchsize' => 250));

			if (!$nodeQry->valid())
			{
				//If we have already scanned all the types, we are done.
				if ($startat >= 5)
				{
					$this->show_message(sprintf($this->phrase['core']['process_done']));
					return;
				}
				return(array('startat' => $startat + 1));
			}

			foreach($nodeQry AS $node)
			{
				$nodeids[] = $node['nodeid'];
			}

			//make sure we have no detritus for these nodes.
			//
			$assertor->assertQuery('vBForum:closure', array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_DELETE,
				'child' => $nodeids));
			//First the record with depth = 0
			$assertor->assertQuery('vBInstall:addClosureSelfForNodes', array('nodeid' => $nodeids));
			//Then the parent records.
			$assertor->assertQuery('vBInstall:addClosureParentsForNodes', array('nodeid' => $nodeids));
			return(array('startat' => $startat));

		}
		else
		{
			$this->skip_message();
		}
	}

	/** Some blog posts are marked approved when they shouldn't be.
	 *
	 */
	public function step_2($data = array())
	{
		if ($this->tableExists('blog') AND $this->tableExists('blog_text'))
		{
			$this->show_message(sprintf($this->phrase['version']['500b9']['fixing_blog_counts_step_x'], 1));
			vB::getDbAssertor()->assertQuery('vBInstall:updateBlogModerated', array());
		}
		else
		{
			$this->skip_message();
		}
	}

	/** The count was incorrect in the vb4 blog table, so let's correct
	 *
	 */
	public function step_3($data = array())
	{
		if ($this->tableExists('blog') AND $this->tableExists('blog_text'))
		{
			$this->show_message(sprintf($this->phrase['version']['500b9']['fixing_blog_counts_step_x'], 2));
			vB::getDbAssertor()->assertQuery('vBInstall:updateBlogCounts', array());
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112203 $
|| #######################################################################
\*=========================================================================*/
