<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_500b26 extends vB_Upgrade_Version
{
	public function step_1()
	{
		//this duplicates a previous step and a future one but step_2
		//requires that the field exist and one of the tests starts from a version
		//that manages to miss the places where the field was added (it was actually added
		//in 504 but some of the code retroactively requires it).
		//
		//It's exceedingly unlikely we'll actually turn up such a database in the wild.
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'page', 1, 1),
			'page',
			'product',
			'VARCHAR',
			array(
				'length' => 25,
				'default' => 'vbulletin',
			)
		);
	}

	// Fixing category field and removing conversation routes for root channels
	public function step_2()
	{
		vB_Upgrade::createSession();

		//some upgrades may not have gotten this column from a step added to 500a1 after the release of that alpha version
		if (!$this->field_exists('channel', 'product'))
		{
			$this->add_field(
				sprintf($this->phrase['core']['altering_x_table'], 'channel', 1, 1),
				'channel',
				'product',
				'VARCHAR',
				array(
					'length' => 25,
					'default' => 'vbulletin',
				)
			);
			$this->execute();
		}

		$this->show_message(sprintf($this->phrase['version']['500b26']['fixing_category_channels']));

		$channels = vB::getDbAssertor()->assertQuery('vBInstall:getRootChannels', array('rootGuids' => array(
			vB_Channel::MAIN_CHANNEL,
			vB_Channel::DEFAULT_FORUM_PARENT,
			vB_Channel::DEFAULT_BLOG_PARENT,
			vB_Channel::DEFAULT_SOCIALGROUP_PARENT,
			vB_Channel::DEFAULT_CHANNEL_PARENT,
		)));

		$library = vB_Library::instance('content_channel');
		foreach ($channels AS $channel)
		{
			if ($channel['category'] == 0 OR !empty($channel['routeid']))
			{
				// Since we are fixing some inconsistencies, we need to force this method to rebuild routes
				$library->switchForumCategory(true, $channel['nodeid'], true);
			}
		}
	}

	/**
	 * Add the nodehash table
	 */
	public function step_3()
	{
		if (!$this->tableExists('nodehash'))
		{
			$this->run_query(
					sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . 'nodehash'),
					"
					CREATE TABLE " . TABLE_PREFIX . "nodehash (
						userid INT UNSIGNED NOT NULL,
						nodeid INT UNSIGNED NOT NULL,
						dupehash char(32) NOT NULL,
						dateline INT UNSIGNED NOT NULL,
						KEY (userid, dupehash),
						KEY (dateline)
					)
					ENGINE = " . $this->hightrafficengine,
					self::MYSQL_ERROR_TABLE_EXISTS
			);
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112183 $
|| #######################################################################
\*=========================================================================*/
