<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_500b23 extends vB_Upgrade_Version
{
	public function step_1()
	{
		/* Clear old widget definitions */
		vB::getDbAssertor()->assertQuery('vBInstall:updateWidgetDefs');
		$this->show_message(sprintf($this->phrase['vbphrase']['update_table'], 'widgetdefinition'));
	}

	/**
	 * Add the table for thread redirects
	 */
	public function step_2()
	{
		if (!$this->tableExists('redirect'))
		{
			$this->run_query(
				sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . 'redirect'),
				"
				CREATE TABLE " . TABLE_PREFIX . "redirect (
					nodeid INT UNSIGNED NOT NULL,
					tonodeid INT UNSIGNED NOT NULL,
					UNIQUE KEY (nodeid)
				) ENGINE = " . $this->hightrafficengine . "
				",
				self::MYSQL_ERROR_TABLE_EXISTS
			);
		}
		else
		{
			$this->skip_message();
		}
	}

	/**
	 * Add content type for thread redirects
	 */
	public function step_3()
	{
		$this->add_contenttype('vbulletin', 'vBForum', 'Redirect');
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
