<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_500b16 extends vB_Upgrade_Version
{
	/* Step #1
	 *
	 * Drop the parent index from closure as we need to extend it with more fields. This may be painful
	 */
	public function step_1()
	{
		$this->drop_index(
			sprintf($this->phrase['core']['altering_x_table'], 'closure', 1, 3),
			'closure',
			'parent'
		);
	}

	/*Step #2
	 *
	 * Add more fields to the parent index on closure for the updateLastData query
	 */
	public function step_2()
	{
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'closure', 2, 3),
			'closure',
			'parent_2',
			array('parent', 'depth', 'publishdate', 'child')
		);
	}

	/*Step #3
	 *
	 * Add index on publishdate for the updateLastData query
	 */
	public function step_3()
	{
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'closure', 3, 3),
			'closure',
			'publishdate',
			array('publishdate', 'child')
		);
	}

	/** Add a message about counts */
	public function step_4()
	{
		$this->add_adminmessage('after_upgrade_from_4',
			array('dismissable' => 1,
			'status'  => 'undone',));
	}

	/*Step #5
	 *
	 * Add index on node for selecting by nodeid and ordering by contenttypeid
	 */
	public function step_5()
	{
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'node', 1, 1),
			'node',
			'nodeid',
			array('nodeid', 'contenttypeid')
		);
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112183 $
|| #######################################################################
\*=========================================================================*/
