<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_500b15 extends vB_Upgrade_Version
{
	/**
	 * Set systemgroupid for those groups
	 * Needed here due beta maintenance, we don't want to rerun old upgraders for this
	 */
	public function step_1()
	{
		if ($this->field_exists('usergroup', 'systemgroupid'))
		{
			vB::getDbAssertor()->assertQuery('vBInstall:alterSystemgroupidField');
		}

		$this->show_message(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'usergroup'));
		vB::getDbAssertor()->assertQuery('vBInstall:setDefaultUsergroups', array());
	}

	/**
	 * Set banned group as custom
	 */
	public function step_2()
	{
		$this->show_message($this->phrase['version']['500b15']['setting_banned_ugp']);
		$ugpOptions = vB::getDatastore()->getValue('bf_ugp_genericoptions');
		vB::getDbAssertor()->assertQuery('vBInstall:setUgpAsDefault',
			array('ugpid' => 8, 'bf_value' => $ugpOptions['isnotbannedgroup'])
		);
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
