<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_500b12 extends vB_Upgrade_Version
{
	/** Add two indices to the route table
	 */
	public function step_1()
	{
		// Add new index
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'routenew', 1, 2),
			'routenew',
			'route_name',
			'name'
		);

	}

	/** Add two indices to the route table
	 */
	public function step_2()
	{
		// Add new index
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'routenew', 2, 2),
			'routenew',
			'route_class_cid',
			array('class', 'contentid')
		);
	}

	/** Make sure every node has a routed
	 */
	public function step_3($data = array())
	{
		$batchsize = 10000;
		if (empty($data['startat']))
		{
			$startat = 0;
		}
		else
		{
			$startat = $data['startat'];
		}
		$this->show_message(sprintf($this->phrase['version']['500b12']['updating_content_routes'], $startat));
		$assertor = vB::getDbAssertor();
		$maxNodeId = $assertor->getRow('vBInstall:getMaxNodeid', array());
		$maxNodeId = $maxNodeId['maxid'];

		if ($startat >= $maxNodeId)
		{
			$this->show_message(sprintf($this->phrase['core']['process_done']));
			return;
		}
		$assertor->assertQuery('vBInstall:fixNodeRouteid', array('startat' => $startat,
			'batchsize' => $batchsize, 'channelContenttypeid' =>  vB_Types::instance()->getContentTypeID('vBForum_Channel')));

		return array('startat' => $startat + $batchsize);
	}

	/** Remove blogcategories from the widgetinstance table	 */
	public function step_4()
	{
		$this->show_message($this->phrase['version']['500b12']['deleting_blog_categories_widget']);
		$assertor = vB::getDbAssertor();
		$widget = $assertor->getRow('widget', array(
			vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT,
			vB_dB_Query::CONDITIONS_KEY => array('guid' => 'vbulletin-widget_blogcategories-4eb423cfd6dea7.34930850')
		));

		$assertor->delete('widgetinstance', array('widgetid' => $widget['widgetid']));
	}

	/** Fix routeid in page table for social group home if needed */
	public function step_5()
	{

		$assertor = vB::getDbAssertor();
		$sgPage = $assertor->getRow('page', array(
			vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT,
			vB_dB_Query::CONDITIONS_KEY => array('routeid' => 0, 'guid' => 'vbulletin-4ecbdac82f2c27.60323372')
		));

		if ($sgPage)
		{
			$this->show_message($this->phrase['version']['500b12']['fix_sghome_routeid']);

			$route = $assertor->getRow('routenew', array(
				vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT,
				vB_dB_Query::CONDITIONS_KEY => array('guid' => 'vbulletin-4ecbdac93742a5.43676037')
			));

			$assertor->update('page',
				array('routeid' => $route['routeid']),
				array('pageid' => $sgPage['pageid'])
			);
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112183 $
|| #######################################################################
\*=========================================================================*/
