<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_500b1 extends vB_Upgrade_Version
{
	/*
	 *	We changed how we choose the table driver for "memory" tables to
	 *	favor Innodb over the memory engine.  Convert the engine here.
	 */
	public function step_1()
	{
		global $db;
		$memory = get_memory_engine($db);
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'cpsession', 1, 1),
			"ALTER TABLE " . TABLE_PREFIX . "cpsession ENGINE = $memory"
		);

		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'session', 1, 1),
			"ALTER TABLE " . TABLE_PREFIX . "session ENGINE = $memory"
		);
	}

	/**
	 * hide the create blog subnav item for usergroups that are not allowed to create blogs
	 */
	public function step_2()
	{
		$this->show_message(sprintf($this->phrase['vbphrase']['update_table'], 'site'));

		$assertor = vB::getDbAssertor();

		$forumpermissions = vB::getDatastore()->getValue('bf_ugp_forumpermissions');
		if (empty($forumpermissions['cancreateblog']))
		{
			$forumpermissions = array();
			$parsedRaw = vB_Xml_Import::parseFile(DIR . '/includes/xml/bitfield_vbulletin.xml');
			foreach ($parsedRaw['bitfielddefs']['group'] AS $group)
			{
				if ($group['name'] == 'ugp')
				{
					foreach($group['group'] AS $bfgroup)
					{
						if ($bfgroup['name'] == 'forumpermissions')
						{
							foreach ($bfgroup['bitfield'] AS $bitfield)
							{
								$forumpermissions[$bitfield['name']] = intval($bitfield['value']);
							}
						}
					}
				}
			}
		}
		//these are the user groups that are allowed to create blogs
		$groups = $assertor->getRows('usergroup', array(
				vB_dB_Query::CONDITIONS_KEY => array(
						array('field' => 'forumpermissions', 'value' => $forumpermissions['cancreateblog'], 'operator' => vB_dB_Query::OPERATOR_AND)
				)
			),
			false,
			'usergroupid'
		);

		$sites = $assertor->assertQuery('vBForum:site');
		foreach ($sites AS $site)
		{
			$changed = false;
			$header = unserialize($site['headernavbar']);
			if (!empty($header))
			{
				foreach ($header as &$h)
				{
					if ($h['title'] == 'navbar_blogs' AND !empty($h['subnav']))
					{
						foreach ($h['subnav'] as &$sn)
						{
							if ($sn['title'] == 'navbar_create_a_new_blog')
							{
								$sn['usergroups'] = array_keys($groups);
								$changed = true;
								break;
							}
						}
					}
				}
			}
			if ($changed)
			{
				$assertor->update('vBForum:site', array('headernavbar' => serialize($header)), array('siteid' => $site['siteid']));
			}
		}
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
