<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_500a9 extends vB_Upgrade_Version
{
	/**
	 * Add default header navbar items
	 */
	public function step_1()
	{
		/* This step was no longer needed 
		as we no longer add the Profile Tab */
		$this->skip_message();
	}

	/**
	 * Change subscribed/subscribers routenew.class name
	 */
	public function step_2()
	{
		if ($this->field_exists('routenew', 'name'))
		{
			$this->run_query(
				sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . "routenew"),
				"UPDATE " . TABLE_PREFIX . "routenew
				SET class = 'vB5_Route_Page'
				WHERE name = 'following' OR name = 'followers'
				"
			);
		}
		else
		{
			$this->skip_message();
		}
	}

	/**
	 * Change subscribed routenew.arguments
	 */
	public function step_3()
	{
		if ($this->field_exists('routenew', 'arguments') AND $this->field_exists('routenew', 'name'))
		{
			$this->run_query(
				sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . "routenew"),
				"UPDATE " . TABLE_PREFIX . "routenew
				SET arguments = '" . serialize(array('pageid' => 9)) . "'
				WHERE name = 'following'
				"
			);
		}
		else
		{
			$this->skip_message();
		}
	}

	/**
	 * Change subscribers routenew.arguments
	 */
	public function step_4()
	{
		if ($this->field_exists('routenew', 'arguments') AND $this->field_exists('routenew', 'name'))
		{
			$this->run_query(
				sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . "routenew"),
				"UPDATE " . TABLE_PREFIX . "routenew
				SET arguments = '" . serialize(array('pageid' => 10)) . "'
				WHERE name = 'followers'
				"
			);
		}
		else
		{
			$this->skip_message();
		}
	}

	/**
	 * Link
	 */
	public function step_5()
	{
		$contenttype = $this->db->query_first("
			SELECT contenttypeid FROM " . TABLE_PREFIX . "contenttype
			WHERE class = 'Link'");
		if (empty($contenttype) OR empty($contenttype['contenttypeid']))
		{
			$this->run_query(
			sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'contenttype'),
			"INSERT INTO " . TABLE_PREFIX . "contenttype(class,
			packageid,	canplace,	cansearch,	cantag,	canattach,	isaggregator)
			SELECT 'Link', packageid, '1', '1', '1', '1', '0'  FROM " . TABLE_PREFIX . "package where class = 'vBForum';");
		}
		else
		{
			$this->skip_message();
		}

		$this->run_query(
		sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . 'link'),
		"
			CREATE TABLE " . TABLE_PREFIX . "link (
				nodeid INT UNSIGNED NOT NULL,
				filedataid INT UNSIGNED NOT NULL DEFAULT '0',
				url VARCHAR(255),
				url_title VARCHAR(255),
				meta MEDIUMTEXT,
				PRIMARY KEY (nodeid),
				KEY (filedataid)
			) ENGINE = " . $this->hightrafficengine . "
		",
		self::MYSQL_ERROR_TABLE_EXISTS
		);
	}

	/**
	 * make search widget clonable
	 */
	public function step_6()
	{
		$skip_message = false;
		$search_results_widget = $this->db->query_first("
			SELECT widgetid FROM " . TABLE_PREFIX . "widget
			WHERE template = 'widget_search'");
		if (!empty($search_results_widget['widgetid']) AND empty($search_results_widget['cloneable']))
		{
			$this->run_query(
				sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'widget'),
				"
				UPDATE `" . TABLE_PREFIX . "widget` SET cloneable = '1' WHERE widgetid = '$search_results_widget[widgetid]'
				"
			);
		}
		else
		{
			$skip_message = true;
		}
	}

	/**
	 * add data in permission table for link and video
	 *
	 */
	public function step_7()
	{
		$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'permission'),
		"UPDATE " . TABLE_PREFIX . "permission
		SET createpermissions = createpermissions | 131072 |262144 WHERE createpermissions > 1;");
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
