<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_500a44 extends vB_Upgrade_Version
{
	/** turn off all access for password-protected forums.  */
	public function step_1()
	{
		if ($this->tableExists('forum'))
		{
			$this->show_message(sprintf($this->phrase['version']['500a44']['importing_forum_perms_1']));
			vB::getDbAssertor()->assertQuery('vBInstall:hidePasswordForums', array('forumTypeid' =>vB_Types::instance()->getContentTypeID('vBForum_Forum')));
		}
		else
		{
			$this->skip_message();
		}
	}

	//Importing forum permissions.
	public function step_2()
	{
		if ($this->tableExists('forum'))
		{
			$this->show_message(sprintf($this->phrase['version']['500a44']['importing_forum_perms_2']));
			$options = vB::getDatastore()->getValue('options');

/*
 			//we moved these from global options to channel by channel usergroup perms in vB5
			//however for varous and sundry reasons we added steps to import the settings
			//earlier and earlier in the upgrade process (so that code we rely on in various places still works)
			//which blows away these values.  This has been setting a lot of things to zeros by accident
			//for some time.  We also never attempted to set any of the new channels we create to these values,
			//instead using some hard coded params.
			$params['maxtags'] = $options['maxtags'];
			$params['maxstartertags'] = $options['tagmaxstarter'];
			$params['maxothertags'] = $options['tagmaxuser'];
			$params['maxattachments'] = $options['attachlimit'];
 */

			//hardcode values based on the defaults in the channel importer.
			$params = [
				'forumTypeid' => vB_Types::instance()->getContentTypeID('vBForum_Forum'),
				'editTime' => $options['noeditedbytime'],
				'maxtags' => 10,
				'maxstartertags' => 5,
				'maxothertags' => 5,
				'maxattachments' => 5,
			];

			vB::getDbAssertor()->assertQuery('vBInstall:setForumPermissions', $params);
		}
		else
		{
			$this->skip_message();
		}
	}

	/* Clear any style settings in user table. Those will only break the display in vB5 */
	public function step_3()
	{
		//We only need to do this if we are upgraded  a vB 3/4 install
		if ($this->tableExists('forum'))
		{
			$this->show_message(sprintf($this->phrase['version']['500a44']['clearing_user_styles']));
			vB::getDbAssertor()->assertQuery('vBInstall:clearUserStyle', array());
		}
	else
		{
			$this->skip_message();
		}
	}

}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112183 $
|| #######################################################################
\*=========================================================================*/
