<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_500a37 extends vB_Upgrade_Version
{
	/** fix screen layouts
	 *
	 */
	public function step_1()
	{
		$screenLayOutRecords = $this->db->query_first("
			SELECT template 
			FROM " . TABLE_PREFIX . "screenlayout
			WHERE screenlayoutid = 1
		");

		if ($screenLayOutRecords['template'] == 'sb_screenlayout_1')
		{
			$this->db->query_write("
				TRUNCATE " . TABLE_PREFIX . "screenlayout
			");

			$this->db->query_write("
				INSERT INTO " . TABLE_PREFIX . "screenlayout
				(screenlayoutid, varname, title, displayorder, columncount, template, admintemplate)
				VALUES
				(1, '100', '100', 4, 1, 'screenlayout_1', 'admin_screenlayout_1'),
				(2, '70-30', '70/30', 1, 2, 'screenlayout_2', 'admin_screenlayout_2'),
				(4, '30-70', '30/70', 3, 2, 'screenlayout_4', 'admin_screenlayout_4')
			");

			$this->show_message(sprintf($this->phrase['vbphrase']['update_table'], 'screenlayout'));

			$this->db->query_write("
				UPDATE " . TABLE_PREFIX . "widget 
				SET template = SUBSTR(template,4)
				WHERE template LIKE 'sb_%'
			");

			$this->show_message(sprintf($this->phrase['vbphrase']['update_table'], 'widget'));
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
