<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_500a33 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->skip_message();
	}

	/**
	* Step #2 - Retire existing vB4 styles
	*
	*/
	public function step_2()
	{
		$this->run_query(
			$this->phrase['version']['500a33']['updating_styles'],
			"UPDATE " . TABLE_PREFIX . "style
			SET userselect = 0,	displayorder = 65432,
			title = IF(title LIKE '%Incompatible%', title, CONCAT(title, ' " . $this->db->escape_string($this->phrase['version']['500a33']['incompatible']) . "'))
			WHERE NOT (dateline = 99999999 OR title LIKE '%" . $this->db->escape_string($this->phrase['version']['500a33']['default_style']) . "%')
		");
	}

	/**
	* Step #3 - Create new vB5 style
	*
	*/
	public function step_3()
	{
		$check = $this->db->query_first("
			SELECT styleid FROM " . TABLE_PREFIX . "style WHERE dateline = 99999999
			OR title LIKE '%" . $this->db->escape_string($this->phrase['version']['500a33']['default_style']) . "%'
		");

		if (!empty($check['styleid']))
		{
			$this->skip_message();
		}
		else
		{
			$this->db->query("
				INSERT INTO " . TABLE_PREFIX . "style
					(title,	parentid, userselect, displayorder, dateline)
					VALUES
					('" . $this->db->escape_string($this->phrase['version']['500a33']['default_style']) . "', -1, 1, 1, 99999999)
			");

			$styleid = $this->db->insert_id();

			$this->run_query(
				$this->phrase['version']['500a33']['creating_default_style'],
				"UPDATE " . TABLE_PREFIX . "style
				SET parentlist = '" . intval($styleid) . ",-1'
				WHERE styleid = " . intval($styleid)
			);

			$this->run_query(
				$this->phrase['version']['500a33']['updating_style'],
				"UPDATE " . TABLE_PREFIX . "setting
				SET value = '" . intval($styleid) . "'
				WHERE varname = 'styleid'
			");
		}
	}

	/**
	* Step #4 - Update some settings
	*
	*/
	public function step_4()
	{
		/* Update the bburl path, this is still used
		by the backend atm and needs to point to the core */
		if ($this->caller == 'cli')
		{
			/* CLI, so just append /core to what exists */
			$this->run_query(
				$this->phrase['version']['500a33']['updating_options'],
				"UPDATE " . TABLE_PREFIX . "setting
				SET value = IF(value LIKE '%/core',	value, CONCAT(value, '/core'))
				WHERE varname = 'bburl'
			");
		}
		else // ajax //
		{
			/* WEB, so try and rebuild it from scratch */
			$port = intval($_SERVER['SERVER_PORT']);
			$port = in_array($port, array(80, 443)) ? '' : ':' . $port;
			$scheme = (($port == ':443') OR (isset($_SERVER['HTTPS']) AND $_SERVER['HTTPS'] AND ($_SERVER['HTTPS'] != 'off'))) ? 'https://' : 'http://';
			$path = $scheme . $_SERVER['SERVER_NAME'] . $port . substr(SCRIPTPATH, 0, strpos(SCRIPTPATH, '/install/'));

			$this->run_query(
				$this->phrase['version']['500a33']['updating_options'],
				"UPDATE " . TABLE_PREFIX . "setting
				SET value = '$path'
				WHERE varname = 'bburl'
			");
		}
	}

	/**
	* Step #5 - Update modcp route
	*
	*/
	public function step_5()
	{

		$this->show_message($this->phrase['version']['500a33']['fix_modcp_route']);
		vB::getDbAssertor()->update('routenew', array('prefix' => 'modcp'), array('regex' => 'modcp/(?P<file>[a-zA-Z0-9_.-]*)'));
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
