<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_500a30 extends vB_Upgrade_Version
{
	/** reseting blog pagetemplates to update blog sidebar **/
	public function step_1()
	{
		vB_Upgrade::createAdminSession();
		// we need to force the page template to be updated
		$blogPageTemplate = vB_Page::getBlogChannelPageTemplate();

		$db = vB::getDbAssertor();

		$this->show_message(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'widgetinstance'));
		$db->delete('widgetinstance', array('pagetemplateid' => $blogPageTemplate));
		$db->delete('pagetemplate', array('pagetemplateid' => $blogPageTemplate));

		// import widgets and pagetemplates
		$this->show_message($this->phrase['final']['import_latest_widgets']);
		$widgetFile = DIR . '/install/vbulletin-widgets.xml';

		if (!($xml = file_read($widgetFile)))
		{
			$this->add_error(sprintf($this->phrase['vbphrase']['file_not_found'], 'vbulletin-widgets.xml'), self::PHP_TRIGGER_ERROR, true);
			return;
		}

		$this->show_message(sprintf($this->phrase['vbphrase']['importing_file'], 'vbulletin-widgets.xml'));
		$xml_importer = new vB_Xml_Import_Widget();
		$xml_importer->importFromFile($widgetFile);
		$this->show_message($this->phrase['core']['import_done']);

		$pageTemplateFile = DIR . '/install/vbulletin-pagetemplates.xml';

		if (!($xml = file_read($pageTemplateFile)))
		{
			$this->add_error(sprintf($this->phrase['vbphrase']['file_not_found'], 'vbulletin-pagetemplates.xml'), self::PHP_TRIGGER_ERROR, true);
			return;
		}

		$this->show_message(sprintf($this->phrase['vbphrase']['importing_file'], 'vbulletin-pagetemplates.xml'));
		$xml_importer = new vB_Xml_Import_PageTemplate('vbulletin', 0);
		$xml_importer->importFromFile($pageTemplateFile);

		// now update pages with new pagetemplate
		$newBlogPageTemplate = vB_Page::getBlogChannelPageTemplate();
		$db->update('page', array('pagetemplateid' => $newBlogPageTemplate), array('pagetemplateid' => $blogPageTemplate));
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112183 $
|| #######################################################################
\*=========================================================================*/
