<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_500a23 extends vB_Upgrade_Version
{
	// Change user's moderatefollowers option enabled by default
	public function step_1()
	{
		$useroptions = vB::getDatastore()->getValue('bf_misc_useroptions');

		if (isset($useroptions['moderatefollowers']))
		{
			$moderatefollowers = $useroptions['moderatefollowers'];
		}
		else
		{
			$moderatefollowers = 67108864;
		}

		$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'user'),
			"UPDATE " . TABLE_PREFIX . "user
			SET options = options | " . $moderatefollowers);
	}

	// Add moderatefollowers to defaultregoptions
	public function step_2()
	{
		$regoptions = vB::getDatastore()->getValue('bf_misc_regoptions');

		if (isset($regoptions['moderatefollowers']))
		{
			$moderatefollowers = $regoptions['moderatefollowers'];
		}
		else
		{
			$moderatefollowers = 134217728;
		}

		$this->run_query(
			sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'setting'),
			"UPDATE " . TABLE_PREFIX . "setting SET
			value = value | " . $moderatefollowers . "
			WHERE varname = 'defaultregoptions'"
		);
	}

	/** Adding styleid field for channels **/
	public function step_3()
	{
		$this->skip_message();
	}

	/** modifying default value for options field in channel **/
	public function step_4()
	{
		$this->skip_message();
	}

	/** migrating forum styleid and options **/
	public function step_5()
	{
		if ($this->tableExists('forum'))
		{
			$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'channel'),
				'UPDATE ' . TABLE_PREFIX . 'channel c
				INNER JOIN ' . TABLE_PREFIX . 'node n ON n.nodeid = c.nodeid
				INNER JOIN ' . TABLE_PREFIX . 'forum f ON f.forumid = n.oldid
				SET c.styleid = f.styleid, c.options = f.options');
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
