<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_500a2 extends vB_Upgrade_Version
{
	public function step_1()
	{
		// insert two new config fields for the video module
		$exists = $this->db->query_first("
			SELECT name
			FROM " . TABLE_PREFIX . "widgetdefinition
			WHERE
				widgetid = 2
					AND
				name = 'provider'
		");
		if (!$exists)
		{
			$this->run_query(
				sprintf($this->phrase['vbphrase']['update_table'], 'widgetdefinition'),
				"
					INSERT INTO `" . TABLE_PREFIX . "widgetdefinition`
					(`widgetid`, `field`, `name`, `label`, `defaultvalue`, `isusereditable`, `isrequired`, `displayorder`, `validationtype`, `validationmethod`, `data`)
					VALUES
					(2, 'Text', 'title', 'Video Title', 'Video Title', 1, 1, 1, '', '', ''),
					(2, 'Select', 'provider', 'Provider', 'youtube', 1, 1, 2, '', '', 'a:2:{s:7:\"youtube\";s:7:\"YouTube\";s:11:\"dailymotion\";s:11:\"DailyMotion\";}')
				"
			);
		}
		else
		{
			$this->skip_message();
		}
	}

	public function step_2()
	{
		// change display order and label for a video module config field
		$this->run_query(
			sprintf($this->phrase['vbphrase']['update_table'], 'widgetdefinition'),
			"
				UPDATE " . TABLE_PREFIX . "widgetdefinition
				SET
					label = 'Video ID',
					displayorder = 3
				WHERE
					widgetid = 2
						AND
					name = 'videoid'
			"
		);
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
