<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_500a19 extends vB_Upgrade_Version
{
	/** removing redundant CRC32 field */
	public function step_1()
	{
		if ($this->field_exists('searchlog', 'CRC32'))
		{
			$this->drop_field(
					sprintf($this->phrase['core']['altering_x_table'], 'searchlog', 1, 1),
					'searchlog',
					'CRC32'
			);
		}
		else
		{
			$this->skip_message();
		}
	}

	/** update nav bar blog link **/
	public function step_2()
	{
		$this->show_message($this->phrase['version']['500a17']['adding_blog_navbar_link']);
		$assertor = vB::getDbAssertor();
		$sites = $assertor->getRows('vBForum:site', array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT));
		foreach ($sites as $site)
		{
			$headerNav = unserialize($site['headernavbar'])	;
			foreach ($headerNav as $key => $nav)
			{
				if (($nav['title'] == 'Blogs') AND ($nav['url'] == '#'))
				{
					$headerNav[$key]['url'] = 'blogs';
					$assertor->assertQuery('vBForum:site', array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_UPDATE,
					'siteid' => $site['siteid'], 'headernavbar' => serialize($headerNav)));
					break;
				}
			}

		}
	}

	/** Blog Posts were originally set to protected, but they shouldn't be. They should be visible. **/
	public function step_3()
	{
		try
		{
			$blogChannel = vB_Library::instance('Blog')->getBlogChannel();
			if (!empty($blogChannel))
			{
				$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'node'),
				"UPDATE " . TABLE_PREFIX . "node AS node INNER JOIN " . TABLE_PREFIX . "closure AS cl ON cl.child = node.nodeid
				AND cl.parent = $blogChannel
				SET node.protected = 0 ;");
			}
			else
			{
				$this->skip_message();
			}
		}
		catch (vB_Exception_Api $e)
		{
			$this->skip_message();
		}
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
