<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_500a14 extends vB_Upgrade_Version
{
	/** Adding UUID field to page table **/
	public function step_1()
	{
		$this->skip_message();
	}

	public function step_2()
	{
		// The problem that I think this step was created to fix was default vBulletin
		// pages that did't have a GUID. I don't think this can happen any more because
		// now we create the page table in 500a1 step1 and import the pages from the XML
		// in 500a1 step131 which runs the final upgrade step to import pages, meaning
		// that all default vB pages should always have their GUID set. That said, fully
		// investigating this is out of scope for what I'm currently doing. Steps 2, 4, 6
		// 8, and 10 in this file are probably all obsolete and can be made no-ops. But,
		// since I can't do that at this point, I'll opt for a non-invasive fix that
		// prevents throwing the exception when duplicate page titles exist in the pages
		// XML file (see the 3 "Forums" home pages we now have, VBV-19556).
		// The fix entails adding the route GUID to the "key" ($title) that is used to
		// identify the unique page. Note steps 1-10 in this file are probably all
		// obsolete, as the GUID should be properly imported in those cases.

		$missing = $this->db->query_read('
			SELECT p.pageid, p.title, p.pagetype, r.guid AS routeguid
			FROM ' . TABLE_PREFIX . 'page AS p
			LEFT JOIN ' . TABLE_PREFIX . 'routenew AS r ON (p.routeid = r.routeid)
			WHERE p.guid IS NULL
		');

		if ($this->db->num_rows($missing) > 0)
		{
			$parsedXml = vB_Xml_Import::parseFile(dirname(__FILE__) . '/../vbulletin-pages.xml');

			$pages = array();
			foreach($parsedXml['page'] AS $t)
			{
				$title = ($t['title'] == 'Forums') ? $t['title'] . '-' . $t['pagetype'] . '-' . $t['routeGuid'] : $t['title'];

				if (isset($pages[$title]))
				{
					throw new Exception("Duplicate id when updating page GUIDs! ($title)");
				}

				$pages[$title] = $t['guid'];
			}

			while ($page = $this->db->fetch_array($missing))
			{
				$title = ($page['title'] == 'Forums') ? $page['title'] . '-' . $page['pagetype'] . '-' . $page['routeguid'] : $page['title'];
				$guid = (isset($pages[$title]) AND !empty($pages[$title])) ? $pages[$title] : vB_Xml_Export_Page::createGUID($page);
				$this->run_query(
					sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'page'),
					"UPDATE " . TABLE_PREFIX . "page
					SET guid = '{$guid}'
					WHERE pageid = {$page['pageid']}"
				);
			}
		}
		else
		{
			$this->skip_message();
		}
	}

	public function step_3()
	{
		$this->skip_message();
	}

	public function step_4()
	{
		$parsedXml = vB_Xml_Import::parseFile(dirname(__FILE__) . '/../vbulletin-pagetemplates.xml');

		$templates = array();
		foreach($parsedXml['pagetemplate'] AS $t)
		{
			if (isset($templates[$t['title']]))
			{
				throw new Exception("Duplicate id when updating page template GUIDs! ({$t['title']})");
			}

			$templates[$t['title']] = $t['guid'];
		}

		$missing = $this->db->query_read('SELECT pagetemplateid, title FROM ' . TABLE_PREFIX . 'pagetemplate WHERE guid IS NULL');

		if ($this->db->num_rows($missing) > 0)
		{
			while ($pagetemplate = $this->db->fetch_array($missing))
			{
				$guid = (isset($templates[$pagetemplate['title']]) AND !empty($templates[$pagetemplate['title']])) ? $templates[$pagetemplate['title']] : vB_Xml_Export::createGUID($pagetemplate);
				$this->run_query(
						sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'pagetemplate'),
						"UPDATE " . TABLE_PREFIX . "pagetemplate
						SET guid = '{$guid}'
						WHERE pagetemplateid = {$pagetemplate['pagetemplateid']}"
				);
			}
		}
		else
		{
			$this->skip_message();
		}
	}

	public function step_5()
	{
		$this->skip_message();
	}

	public function step_6()
	{
		$this->skip_message();
	}

	public function step_7()
	{
		$this->skip_message();
	}

	public function step_8()
	{
		$parsedXml = vB_Xml_Import::parseFile(dirname(__FILE__) . '/../vbulletin-channels.xml');

		$channels = array();
		foreach($parsedXml['channel'] AS $t)
		{
			if (isset($channels[$t['node']['title']]))
			{
				throw new Exception("Duplicate id when updating channel GUIDs! ({$t['node']['title']})");
			}

			$channels[$t['node']['title']] = $t['guid'];
		}

		$missing = $this->db->query_read(
			'SELECT c.nodeid, n.title
			FROM ' . TABLE_PREFIX . 'channel AS c
			INNER JOIN ' . TABLE_PREFIX . 'node AS n ON n.nodeid = c.nodeid
			WHERE guid IS NULL'
		);

		if ($this->db->num_rows($missing) > 0)
		{
			while ($channel = $this->db->fetch_array($missing))
			{
				$guid = (isset($channels[$channel['title']]) AND !empty($channels[$channel['title']])) ? $channels[$channel['title']] : vB_Xml_Export::createGUID($channel);
				$this->run_query(
						sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'channel'),
						"UPDATE " . TABLE_PREFIX . "channel
						SET guid = '{$guid}'
						WHERE nodeid = {$channel['nodeid']}"
				);
			}
		}
		else
		{
			$this->skip_message();
		}
	}

	public function step_9()
	{
		$this->skip_message();
	}

	public function step_10()
	{
		$parsedXml = vB_Xml_Import::parseFile(dirname(__FILE__) . '/../vbulletin-routes.xml');

		$routes = [];
		foreach($parsedXml['route'] AS $t)
		{
			//The class isn't set for all routes in the xml.  It will be blank if it's not specified.
			//Note that the "title" isn't used aside from matching existing routes to the xml values
			$title = $t['prefix'] . '-' . ($t['class'] ?? '');
			if (isset($routes[$title]))
			{
				throw new Exception("Duplicate id when updating route GUIDs! ({$title})");
			}

			$routes[$title] = $t['guid'];
		}

		$missing = $this->db->query_read('SELECT routeid, prefix, class FROM ' . TABLE_PREFIX . 'routenew WHERE guid IS NULL');

		if ($this->db->num_rows($missing) > 0)
		{
			while ($route = $this->db->fetch_array($missing))
			{
				$temp_id = $route['prefix'] . '-' . $route['class'];
				$guid = (!empty($routes[$temp_id]) ? $routes[$temp_id] : vB_Xml_Export::createGUID($route));
				$this->run_query(
					sprintf($this->phrase['vbphrase']['update_table'], 'routenew'),
					"UPDATE " . TABLE_PREFIX . "routenew
					SET guid = '{$guid}'
					WHERE routeid = {$route['routeid']}"
				);
			}
		}
		else
		{
			$this->skip_message();
		}
	}

	// Update old reputation table
	public function step_11()
	{
		$this->skip_message();
	}

	//Set nodeid in reputation table.
	public function step_12($data = NULL)
	{
		if (empty($data['startat']))
		{
			$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], TABLE_PREFIX . 'reputation', 1, 2));
		}

		$callback = function($startat, $nextid)
		{
			$postTypeId = vB_Types::instance()->getContentTypeID('vBForum_Post');

			vB::getDbAssertor()->assertQuery('vBInstall:setReputationNodeid', array(
				'oldcontenttypeid' => $postTypeId,
				'startat' => $startat,
				'nextid' => $nextid,
			));
		};

		$batchsize = $this->getBatchSize('small', __FUNCTION__);
		return $this->updateByIdWalk($data, $batchsize, 'vBInstall:getMaxReputationid', 'vBForum:reputation', 'reputationid', $callback);
	}

	public function step_13($data = NULL)
	{
		if (empty($data['startat']))
		{
			$this->show_message(sprintf($this->phrase['vbphrase']['update_table_x'], TABLE_PREFIX . 'reputation', 2, 2));
		}

		$callback = function($startat, $nextid)
		{
			$threadTypeId = vB_Types::instance()->getContentTypeID('vBForum_Thread');

			vB::getDbAssertor()->assertQuery('vBInstall:setReputationNodeidThread', array(
				'oldcontenttypeid' => $threadTypeId,
				'startat' => $startat,
				'nextid' => $nextid,
			));
		};

		$batchsize = $this->getBatchSize('xsmall', __FUNCTION__);
		return $this->updateByIdWalk($data, $batchsize, 'vBInstall:getMaxReputationid', 'vBForum:reputation', 'reputationid', $callback);
	}

	// Update reputation table
	public function step_14()
	{
		// Drop orphans
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'reputation', 1, 3),
			"DELETE FROM " . TABLE_PREFIX . "reputation
			WHERE nodeid = 0"
		);

	}
	// Update reputation table
	public function step_15()
	{
		// Add new index
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'reputation', 2, 3),
			'reputation',
			'whoadded_nodeid',
			array('whoadded', 'nodeid'),
			'unique'
		);

	}
	// Update reputation table
	public function step_16()
	{
		// Add new index
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'reputation', 3, 3),
			'reputation',
			'multi',
			array('nodeid', 'userid')
		);

	}

	public function step_17()
	{
		// Drop nodevote table
		$this->run_query(
			sprintf($this->phrase['core']['dropping_old_table_x'], TABLE_PREFIX . "nodevote"),
			"DROP TABLE IF EXISTS " . TABLE_PREFIX . "nodevote"
		);
	}

	/*
	 * VBV-6546 : Set node hasphoto value
	 */
	public function step_18($data = [])
	{
		$process = 2500;
		$maxnode = intval($data['maxnode'] ?? 0);
		$startat = intval($data['startat'] ?? 0);

		if ($startat == 0)
		{
			// Initial pass, get max nodeid
			$data = $this->db->query_first("
				SELECT MAX(nodeid) AS maxnode
				FROM " . TABLE_PREFIX . "text
			");

			$maxnode = intval($data['maxnode']);

			if (!$maxnode)
			{ // Nothing to process (unlikely ....)
				$this->skip_message();
				return;
			}

			$this->show_message($this->phrase['version']['500a14']['processing_photos']);
			return array('startat' => 1, 'maxnode' => $maxnode);
		}
		else
		{	// Subsequent passes
			$first = $startat;
			$last = $first + $process - 1;

			if ($first > $maxnode)
			{
				$this->show_message($this->phrase['version']['500a14']['update_photos_complete']);
				return;
			}
		}

		$nodes = $this->db->query_read_slave("
			SELECT n.nodeid, t.rawtext, n.hasphoto
			FROM " . TABLE_PREFIX . "node AS n
			INNER JOIN " . TABLE_PREFIX . "text as t
			USING (nodeid)
			WHERE n.nodeid >= $first AND n.nodeid <= $last
		");

		$nodelist = array();
		$rows = $this->db->num_rows($nodes);

		if ($rows)
		{
			while ($node = $this->db->fetch_array($nodes))
			{
				if (!$node['hasphoto']
				// Make sure we have an opening and closing tag
				AND strripos($node['rawtext'], '[attach') !== false
				AND strripos($node['rawtext'], '[/attach') !== false)
				{
					$nodelist[] = $node['nodeid'];
				}
			}
		}

		if ($nodelist)
		{
			$nodes = implode(',', $nodelist);

			$this->db->query_write("
				UPDATE " . TABLE_PREFIX . "node
				SET hasphoto = 1
				WHERE nodeid IN ($nodes)
			");
		}

		$this->show_message(sprintf($this->phrase['version']['500a14']['processed_nodes'], $first, $last, $rows));

		return array('startat' => $last + 1, 'maxnode' => $maxnode);
	}

	/*
	 * VBV-6546 : Set node hasvideo value
	 */
	public function step_19($data = [])
	{
		$process = 2500;
		$maxnode = intval($data['maxnode'] ?? 0);
		$startat = intval($data['startat'] ?? 0);

		if ($startat == 0)
		{
			// Initial pass, get max nodeid
			$data = $this->db->query_first("
				SELECT MAX(nodeid) AS maxnode
				FROM " . TABLE_PREFIX . "text
			");

			$maxnode = intval($data['maxnode']);

			if (!$maxnode)
			{
				// Nothing to process (unlikely ....)
				$this->skip_message();
				return;
			}

			$this->show_message($this->phrase['version']['500a14']['processing_videos']);
			return array('startat' => 1, 'maxnode' => $maxnode);
		}
		else
		{	// Subsequent passes
			$first = $startat;
			$last = $first + $process - 1;

			if ($first > $maxnode)
			{
				$this->show_message($this->phrase['version']['500a14']['update_videos_complete']);
				return;
			}
		}

		$nodes = $this->db->query_read_slave("
			SELECT n.nodeid, t.rawtext, n.hasvideo
			FROM " . TABLE_PREFIX . "node AS n
			INNER JOIN " . TABLE_PREFIX . "text as t
			USING (nodeid)
			WHERE n.nodeid >= $first AND n.nodeid <= $last
		");

		$nodelist = array();
		$rows = $this->db->num_rows($nodes);

		if ($rows)
		{
			while ($node = $this->db->fetch_array($nodes))
			{
				if (!$node['hasvideo']
				// Make sure we have an opening and closing tag
				AND strripos($node['rawtext'], '[video') !== false
				AND strripos($node['rawtext'], '[/video') !== false)
				{
					$nodelist[] = $node['nodeid'];
				}
			}
		}

		if ($nodelist)
		{
			$nodes = implode(',', $nodelist);

			$this->db->query_write("
				UPDATE " . TABLE_PREFIX . "node
				SET hasvideo = 1
				WHERE nodeid IN ($nodes)
			");
		}

		$this->show_message(sprintf($this->phrase['version']['500a14']['processed_nodes'], $first, $last, $rows));

		return array('startat' => $last + 1, 'maxnode' => $maxnode);
	}

	//For handling private message deletion
	public function step_20()
	{
		$this->skip_message();
	}

	//cron job for private message deletion.
	public function step_21()
	{
		$assertor = vB::getDbAssertor();
		$existing = $assertor->getRow('cron', array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT,
			'varname' => 'privatemessages'));
		if ($existing AND empty($existing['errors']))
		{
			$this->skip_message();
		}
		else
		{
			$data = array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_INSERT,
			'nextrun' =>  vB::getRequest()->getTimeNow(), 'weekday' => -1, 'day' => -1,
			'hour' => -1, 'minute' => 'a:1:{i:0;i:40;}','filename' => './includes/cron/privatemessage_cleanup.php',
			'loglevel' => 1, 'varname' => 'privatemessages', 'volatile' => 1,'product' => 'vbulletin');

			$assertor->assertQuery('cron', $data);
			$this->show_message($this->phrase['version']['500a14']['adding_pm_scheduled_task']);
		}

		$this->long_next_step();
	}

	/**
	 * Remove following widget information
	 */
	public function step_22()
	{
		$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'routenew'),
			"DELETE FROM " . TABLE_PREFIX . "routenew WHERE guid = 'vbulletin-4ecbdacd6a7ef6.07321454'"
		);

		$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'page'),
			"DELETE FROM " . TABLE_PREFIX . "page WHERE guid = 'vbulletin-4ecbdac82f17e1.17839721'"
		);

		// get the pagetemplateid to delete pages and routenew records
		$templateInfo = $this->db->query_first("
			SELECT pagetemplateid FROM " . TABLE_PREFIX . "pagetemplate
			WHERE guid = 'vbulletin-4ecbdac9373089.38426136'"
		);

		if ($templateInfo AND isset($templateInfo['pagetemplateid']) AND !empty($templateInfo['pagetemplateid']))
		{
			$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'pagetemplate'),
				"DELETE FROM " . TABLE_PREFIX . "pagetemplate WHERE pagetemplateid = " . $templateInfo['pagetemplateid']
			);

			// fetch pages using the template
			$pages = $this->db->query_read("
				SELECT pageid, routeid FROM " . TABLE_PREFIX . "page
				WHERE pagetemplateid = " . $templateInfo['pagetemplateid']
			);
			$pageIds = array();
			$routeIds = array();
			while ($page = $this->db->fetch_array($pages))
			{
				$pageIds[] = $page['pageid'];
				$routeIds[] = $page['routeid'];
			}

			// delete page...
			if (!empty($pageIds))
			{
				$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'page'),
					"DELETE FROM " . TABLE_PREFIX . "page WHERE pageid IN (" . implode(', ', $pageIds) . ")"
				);
			}
		}

		// ...and routenew records
		if (!empty($routeIds))
		{
			$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'routenew'),
				"DELETE FROM " . TABLE_PREFIX . "routenew WHERE routeid IN (" . implode(', ', $routeIds) . ")"
			);
		}

		// now from widget tables
		$widgetInfo = $this->db->query_first("
			SELECT widgetid FROM " . TABLE_PREFIX . "widget
			WHERE guid = 'vbulletin-widget_following-4eb423cfd6c778.30550576'"
		);

		if ($widgetInfo AND isset($widgetInfo['widgetid']) AND !empty($widgetInfo['widgetid']))
		{
			$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'widget'),
				"DELETE FROM " . TABLE_PREFIX . "widget WHERE guid = 'vbulletin-widget_following-4eb423cfd6c778.30550576'"
			);

			$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'widgetdefinition'),
				"DELETE FROM " . TABLE_PREFIX . "widgetdefinition WHERE widgetid = " . $widgetInfo['widgetid']
			);

			$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'widgetinstance'),
				"DELETE FROM " . TABLE_PREFIX . "widgetinstance WHERE widgetid = " . $widgetInfo['widgetid']
			);
		}

		$this->long_next_step();
	}

	/**
	 * Remove followers widget information
	 */
	public function step_23()
	{
		$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'routenew'),
			"DELETE FROM " . TABLE_PREFIX . "routenew WHERE guid = 'vbulletin-4ecbdacd6a8b25.50710303'"
		);

		$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'page'),
			"DELETE FROM " . TABLE_PREFIX . "page WHERE guid = 'vbulletin-4ecbdac82f1bf0.76172990'"
		);

		// get the pagetemplateid to delete pages and routenew records
		$templateInfo = $this->db->query_first("
			SELECT pagetemplateid FROM " . TABLE_PREFIX . "pagetemplate
			WHERE guid = 'vbulletin-4ecbdac9373422.51068894'"
		);

		if ($templateInfo AND !empty($templateInfo['pagetemplateid']))
		{
			$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'pagetemplate'),
				"DELETE FROM " . TABLE_PREFIX . "pagetemplate WHERE pagetemplateid = " . $templateInfo['pagetemplateid']
			);

			// fetch pages using the template
			$pages = $this->db->query_read("
				SELECT pageid, routeid FROM " . TABLE_PREFIX . "page
				WHERE pagetemplateid = " . $templateInfo['pagetemplateid']
			);

			$pageIds = [];
			$routeIds = [];
			while ($page = $this->db->fetch_array($pages))
			{
				$pageIds[] = $page['pageid'];
				$routeIds[] = $page['routeid'];
			}

			// delete page...
			if (!empty($pageIds))
			{
				$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'page'),
					"DELETE FROM " . TABLE_PREFIX . "page WHERE pageid IN (" . implode(', ', $pageIds) . ")"
				);
			}

			// and routenew records
			if (!empty($routeIds))
			{
				$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'routenew'),
					"DELETE FROM " . TABLE_PREFIX . "routenew WHERE routeid IN (" . implode(', ', $routeIds) . ")"
				);
			}
		}

		// now from widget tables
		$widgetInfo = $this->db->query_first("
			SELECT widgetid FROM " . TABLE_PREFIX . "widget
			WHERE guid = 'vbulletin-widget_followers-4eb423cfd6cac2.78540773'"
		);

		if ($widgetInfo AND !empty($widgetInfo['widgetid']))
		{
			$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'widget'),
				"DELETE FROM " . TABLE_PREFIX . "widget WHERE guid = 'vbulletin-widget_followers-4eb423cfd6cac2.78540773'"
			);

			$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'widgetdefinition'),
				"DELETE FROM " . TABLE_PREFIX . "widgetdefinition WHERE widgetid = " . $widgetInfo['widgetid']
			);

			$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'widgetinstance'),
				"DELETE FROM " . TABLE_PREFIX . "widgetinstance WHERE widgetid = " . $widgetInfo['widgetid']
			);
		}

		$this->long_next_step();
	}

	/**
	 * Remove groups widget information
	 */
	public function step_24()
	{
		$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'routenew'),
			"DELETE FROM " . TABLE_PREFIX . "routenew WHERE guid = 'vbulletin-4ecbdacd6a8f29.89433296'"
		);

		$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'page'),
			"DELETE FROM " . TABLE_PREFIX . "page WHERE guid = 'vbulletin-4ecbdac82f2008.58648267'"
		);

		// get the pagetemplateid to delete pages and routenew records
		$templateInfo = $this->db->query_first("
			SELECT pagetemplateid FROM " . TABLE_PREFIX . "pagetemplate
			WHERE guid = 'vbulletin-4ecbdac93737c2.35059434'"
		);

		if ($templateInfo AND !empty($templateInfo['pagetemplateid']))
		{
			$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'pagetemplate'),
				"DELETE FROM " . TABLE_PREFIX . "pagetemplate WHERE pagetemplateid = " . $templateInfo['pagetemplateid']
			);

			// fetch pages using the template
			$pages = $this->db->query_read("
				SELECT pageid, routeid FROM " . TABLE_PREFIX . "page
				WHERE pagetemplateid = " . $templateInfo['pagetemplateid']
			);

			$pageIds = [];
			$routeIds = [];
			while ($page = $this->db->fetch_array($pages))
			{
				$pageIds[] = $page['pageid'];
				$routeIds[] = $page['routeid'];
			}

			// delete page...
			if (!empty($pageIds))
			{
				$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'page'),
					"DELETE FROM " . TABLE_PREFIX . "page WHERE pageid IN (" . implode(', ', $pageIds) . ")"
				);
			}

			// ...and routenew records
			if (!empty($routeIds))
			{
				$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'routenew'),
					"DELETE FROM " . TABLE_PREFIX . "routenew WHERE routeid IN (" . implode(', ', $routeIds) . ")"
				);
			}
		}

		// now from widget tables
		$widgetInfo = $this->db->query_first("
			SELECT widgetid FROM " . TABLE_PREFIX . "widget
			WHERE guid = 'vbulletin-widget_groups-4eb423cfd6ce25.12220055'"
		);


		if ($widgetInfo AND !empty($widgetInfo['widgetid']))
		{
			$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'widget'),
				"DELETE FROM " . TABLE_PREFIX . "widget WHERE guid = 'vbulletin-widget_groups-4eb423cfd6ce25.12220055'"
			);

			$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'widgetdefinition'),
				"DELETE FROM " . TABLE_PREFIX . "widgetdefinition WHERE widgetid = " . $widgetInfo['widgetid']
			);

			$this->run_query(sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'widgetinstance'),
				"DELETE FROM " . TABLE_PREFIX . "widgetinstance WHERE widgetid = " . $widgetInfo['widgetid']
			);
		}
	}

	// Set all users to have collapsed signature by default
	public function step_25()
	{
		$bf_misc_useroptions = vB::getDatastore()->get_value('bf_misc_useroptions');

		$this->run_query(
			sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'user'),
			"UPDATE " . TABLE_PREFIX . "user
			SET options = options - {$bf_misc_useroptions['showsignatures']}
			WHERE (options & {$bf_misc_useroptions['showsignatures']})"
		);
	}


	//Add setfor- needed for Visitor Message.
	public function step_26()
	{
		$assertor = vB::getDbAssertor();

		$current = $assertor->getRows('routenew', array('name' => 'album'));

		if (empty($current) OR !empty($current['routeid']))
		{
			$this->show_message($this->phrase['version']['500a13']['adding_album_widget']);

			$data = array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_INSERT,
			'title' => 'Album Template', 'screenlayoutid' => 1);
			$pagetemplateid = $assertor->assertQuery('pagetemplate', $data);
			$pagetemplateid = $pagetemplateid[0];

			$data = array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_INSERT,
			'parentid' => 0, 'pagetemplateid' => $pagetemplateid, 'title' => 'Album',
			'metadescription' => 'vBulletin Photo Album',
			'routeid' => 10, 'displayorder' => 1, 'pagetype' => 'custom');
			$pageid = $assertor->assertQuery('page', $data);
			$pageid = $pageid[0];

			$data = array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_INSERT,
			'name' => 'album', 'prefix' => 'album', 'regex' => 'album/(?P<nodeid>[0-9]+)(?P<title>(-[^!@\\#\\$%\\^&\\*\\(\\)\\+\\?/:;"\'\\\\,\\.<>= _]*)*)',
			'class' => 'vB5_Route_album','controller' => 'page','action' => 'index',
			'template' => 'widget_album','arguments' => serialize(array('contentid' => $pageid)),'contentid' => $pageid);

			$routeid = $assertor->assertQuery('routenew', $data);
			$routeid = $routeid[0];

			$data = array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_UPDATE,
			'pageid' => $pageid, 'routeid' => $routeid);

			$assertor->assertQuery('page', $data);

			$data = array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_INSERT,
			'pagetemplateid' => $pagetemplateid, 'widgetid' => 30, 'displaysection' => 0,
			'displayorder' => 0);

			$assertor->assertQuery('widgetinstance', $data);
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112203 $
|| #######################################################################
\*=========================================================================*/
