<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_500a11 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->skip_message();
	}

	public function step_2()
	{
		$this->skip_message();
	}

	/**
	 * Report / Flag
	 */
	public function step_3()
	{
		// Reports Channel
		$reportChannel = $this->db->query_first("
			SELECT node.nodeid, node.oldcontenttypeid
			FROM " . TABLE_PREFIX . "node AS node
			INNER JOIN " . TABLE_PREFIX . "channel AS channel ON (node.nodeid = channel.nodeid)
			WHERE channel.guid = '" . vB_Channel::REPORT_CHANNEL . "'");
		$oldContentTypeId = 9997;
		if (!empty($reportChannel) AND $reportChannel['oldcontenttypeid'] != $oldContentTypeId)
		{
			// Set the oldcontenttypeid and oldid if they're not set. The channel should've already been created in 500a1.
			$query = "
			UPDATE " . TABLE_PREFIX . "node
			SET oldid = 1, oldcontenttypeid = " . $oldContentTypeId . "
			WHERE nodeid = " . $reportChannel['nodeid'];
			$this->show_message(sprintf($this->phrase['vbphrase']['update_table'], 'node'));
			$this->db->query_write(
				$query);
		}
		else
		{
			$this->skip_message();
		}

		$contenttype = $this->db->query_first("
			SELECT contenttypeid FROM " . TABLE_PREFIX . "contenttype
			WHERE class = 'Report'");
		if (empty($contenttype) OR empty($contenttype['contenttypeid']))
		{
			$this->run_query(
			sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'contenttype'),
			"INSERT INTO " . TABLE_PREFIX . "contenttype(class,
			packageid,	canplace,	cansearch,	cantag,	canattach,	isaggregator)
			SELECT 'Report', packageid, '0', '0', '0', '0', '0'  FROM " . TABLE_PREFIX . "package where class = 'vBForum';");
		}
		else
		{
			$this->skip_message();
		}

		$this->run_query(
		sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . 'link'),
		"
			CREATE TABLE " . TABLE_PREFIX . "report (
				nodeid INT UNSIGNED NOT NULL,
				reportnodeid INT UNSIGNED NOT NULL DEFAULT '0',
				closed SMALLINT(5) UNSIGNED NOT NULL DEFAULT '0',
				PRIMARY KEY (nodeid),
				KEY (reportnodeid, closed)
			) ENGINE = " . $this->hightrafficengine . "
		",
		self::MYSQL_ERROR_TABLE_EXISTS
		);
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
