<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_500a10 extends vB_Upgrade_Version
{
	/**
	 * Change settings routenew.name class
	 */
	public function step_1()
	{
		$this->skip_message();
	}

	/**
	 * Change settings routenew.arguments
	 */
	public function step_2()
	{
		$this->skip_message();
	}

	/**
	 * Change showpublished field to 1 for Albums and Private Messages
	 */
	public function step_3()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . "node"),
			"UPDATE " . TABLE_PREFIX . "node
			SET showpublished = '1'
			WHERE showpublished = '0' AND
				contenttypeid = '23' AND
				title IN ('Albums', 'Private Messages')
			"
		);
	}

	/*** Add index on nodeid to the moderators table */
	public function step_4()
	{
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'moderator', 1, 1),
			'moderator',
			'nodeid',
			'nodeid'
		);
	}


	/*** set the nodeid for moderators */
	public function step_5()
	{
		$this->show_message(sprintf($this->phrase['vbphrase']['update_table'], 'moderator'));
		vB::getDbAssertor()->assertQuery('vBInstall:setModeratorNodeid',
			array('forumTypeId' => vB_Types::instance()->getContentTypeID('vBForum_Forum')));
	}

	/*** Add index on nodeid to the moderatorlog table */
	public function step_6()
	{
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'moderatorlog', 1, 1),
			'moderatorlog',
			'nodeid',
			'nodeid'
		);
	}


	/*** set the nodeid for moderatorlog */
	public function step_7()
	{
		$this->show_message(sprintf($this->phrase['vbphrase']['update_table'], 'moderatorlog'));
		vB::getDbAssertor()->assertQuery('vBInstall:setModeratorlogThreadid',
			array('threadTypeId' => vB_Types::instance()->getContentTypeID('vBForum_Thread')));
	}

	/*** Add index on nodeid to the access table */
	public function step_8()
	{
		$this->skip_message();
	}


	/*** set the nodeid for access */
	public function step_9()
	{
		$this->skip_message();
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
