<?php
/*======================================================================*\
|| #################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved. ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------- VBULLETIN IS NOT FREE SOFTWARE ---------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html # ||
|| #################################################################### ||
\*======================================================================*/


class vB_Upgrade_424b1 extends vB_Upgrade_Version
{
	/**
	* Check attachment refcounts and fix any that are broken
	*/
	public function step_1()
	{
		$sql = "
			UPDATE " . TABLE_PREFIX . "filedata
			LEFT JOIN (
				SELECT filedataid, COUNT(attachmentid) AS actual
				FROM " . TABLE_PREFIX . "attachment
				GROUP BY filedataid
			) list USING (filedataid) 
			SET refcount = IFNULL(actual, 0)
			WHERE refcount <> IFNULL(actual, 0)
		";

		$res = $this->run_query(sprintf($this->phrase['vbphrase']['update_table_x'], 'filedata', 1, 1), $sql);
	}

	/*
	Step 2 Moved, it is now 5.2.3 Alpha 5, Step 2 
	Step 3 Moved, it is now 5.2.3 Alpha 5, Step 3 
	Step 4 Moved, it is now 5.2.3 Alpha 5, Step 4 
	Step 5 Moved, it is now 5.2.3 Alpha 5, Step 5 
	Step 6 Removed, it was an update to the Post Table, unused in vB5 
	*/
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112180 $
|| ####################################################################
\*======================================================================*/
