<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_415b1 extends vB_Upgrade_Version
{
	/**
	* Step #1 - Add api post log table
	*
	*/
	public function step_1()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . 'apipost'),
			"CREATE TABLE " . TABLE_PREFIX . "apipost (
			  apipostid INT UNSIGNED NOT NULL AUTO_INCREMENT,
			  userid INT UNSIGNED NOT NULL DEFAULT '0',
			  contenttypeid INT UNSIGNED NOT NULL DEFAULT '0',
			  contentid INT UNSIGNED NOT NULL DEFAULT '0',
			  clientname VARCHAR(250) NOT NULL DEFAULT '',
			  clientversion VARCHAR(50) NOT NULL DEFAULT '',
			  platformname VARCHAR(250) NOT NULL DEFAULT '',
			  platformversion VARCHAR(50) NOT NULL DEFAULT '',
			  PRIMARY KEY (apipostid),
			  KEY contenttypeid (contenttypeid, contentid)
			)",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}
	
	/**
	* Step #2 - VBIV-7754, increase field size
	*
	*/
	public function step_2()
	{
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'searchlog', 1, 1),
			"ALTER TABLE " . TABLE_PREFIX . "searchlog CHANGE criteria criteria MEDIUMTEXT NOT NULL"
		);
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
