<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_411b1 extends vB_Upgrade_Version
{
	public function step_1()
	{
		//delete any orphaned cms_article records. These are created by deleting articles from
		// the admincp content manager, fixed in this release.
		$contentinfo = $this->db->query_first("SELECT c.contenttypeid FROM " . TABLE_PREFIX .
		"contenttype c INNER JOIN " . TABLE_PREFIX . "package AS p ON p.packageid = c.packageid
		WHERE c.class='Article' AND p.productid = 'vbcms' ;");

		if ($contentinfo AND $contentinfo['contenttypeid'])
		{
			$this->run_query(
			$this->phrase['version']['411']['delete_orphan_articles'],
			"DELETE a FROM " . TABLE_PREFIX . "cms_article AS a LEFT JOIN " . TABLE_PREFIX .
			"cms_node AS n ON (n.contentid = a.contentid AND n.contenttypeid = " . $contentinfo['contenttypeid'] .")
			WHERE n.contentid IS NULL;");
		}
		else
		{
			$this->skip_message();
		}
	}

	public function step_2()
	{
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'cache', 1, 1),
			"ALTER TABLE " . TABLE_PREFIX . "cache CHANGE data data MEDIUMTEXT"
		);
	}

	public function step_3()
	{
		//From 4.1.0 we could have a setting record with volatile = 0. That would be bad in finalupgrade.
			$this->run_query(
			sprintf($this->phrase['version']['411']['setting_volatile_flag'], 'socnet'),
			"UPDATE " . TABLE_PREFIX . "setting SET volatile=1 where varname='socnet';");

	}
 }

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
