<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_410b1 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . 'apiclient'),
			"CREATE TABLE " . TABLE_PREFIX . "apiclient (
				apiclientid INT UNSIGNED NOT NULL auto_increment,
				secret VARCHAR(32) NOT NULL DEFAULT '',
				apiaccesstoken VARCHAR(32) NOT NULL DEFAULT '',
				userid INT UNSIGNED NOT NULL DEFAULT '0',
				clienthash VARCHAR(32) NOT NULL DEFAULT '',
				clientname VARCHAR(250) NOT NULL DEFAULT '',
				clientversion VARCHAR(50) NOT NULL DEFAULT '',
				platformname VARCHAR(250) NOT NULL DEFAULT '',
				platformversion VARCHAR(50) NOT NULL DEFAULT '',
				uniqueid VARCHAR(250) NOT NULL DEFAULT '',
				initialipaddress VARCHAR(15) NOT NULL DEFAULT '',
				dateline INT UNSIGNED NOT NULL,
				lastactivity INT UNSIGNED NOT NULL,
				PRIMARY KEY  (apiclientid),
				KEY clienthash (uniqueid)
			)",
			self::MYSQL_ERROR_TABLE_EXISTS
		);

	}

	public function step_2()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'session', 1, 3),
			'session',
			'apiclientid',
			'INT',
			self::FIELD_DEFAULTS
		);
	}

	public function step_3()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'session', 2, 3),
			'session',
			'apiaccesstoken',
			'VARCHAR',
			array('length' => 32, 'attributes' => self::FIELD_DEFAULTS)
		);
	}

	public function step_4()
	{
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'session', 3, 3),
			'session',
			'apiaccesstoken',
			'apiaccesstoken'
		);
	}

	public function step_5()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . 'apilog'),
			"CREATE TABLE " . TABLE_PREFIX . "apilog (
				apilogid INT UNSIGNED NOT NULL auto_increment,
				apiclientid INT UNSIGNED NOT NULL DEFAULT '0',
				dateline INT UNSIGNED NOT NULL DEFAULT '0',
				method VARCHAR(32) NOT NULL DEFAULT '',
				paramget MEDIUMTEXT,
				parampost MEDIUMTEXT,
				ipaddress VARCHAR(15) NOT NULL DEFAULT '',
				PRIMARY KEY  (apilogid),
				KEY apiclientid (apiclientid, method, dateline)
			)",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
