<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_406 extends vB_Upgrade_Version
{
	public function step_1()
	{
		// fix imgdir_gradients stylevar in non-MASTER styles VBIV-8052
		$stylevar_result = $this->db->query_read("
			SELECT *
			FROM " . TABLE_PREFIX . "stylevar
			WHERE stylevarid = 'imgdir_gradients'
		");

		$stylevars = array();

		while ($stylevar = $this->db->fetch_array($stylevar_result))
		{
			if ($stylevar['styleid'] == -1)
			{
				continue;
			}

			$value = unserialize($stylevar['value']);
			if (key($value) == 'string')
			{
				$stylevars[] = $stylevar;
			}
		}

		$total = count($stylevars);

		if ($total > 0)
		{
			$i = 1;
			foreach ($stylevars AS $stylevar)
			{
				$value = unserialize($stylevar['value']);
				$new_value = array('imagedir' => $value['string']);

				$this->run_query(
					sprintf($this->phrase['version']['406']['updating_stylevars_in_styleid_x_y_of_z'], $stylevar['styleid'], $i, $total),
					"UPDATE " . TABLE_PREFIX . "stylevar
					SET value = '" . $this->db->escape_string(serialize($new_value)) . "'
					WHERE
						stylevarid = 'imgdir_gradients'
							AND
						styleid = " . intval($stylevar['styleid']) . "
				");
				$i++;
			}
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
