<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_404 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'userchangelog', 1, 1),
			'userchangelog',
			'ipaddress',
			'int',
			self::FIELD_DEFAULTS
		);
	}

	/**
	* Step #2 - remove orphaned stylevars
	*
	*/
	public function step_2()
	{
		$this->show_message($this->phrase['version']['404']['checking_orphaned_stylevars']);

		$skipstyleids = '-1';
		$style_result = $this->db->query_read("SELECT styleid FROM " . TABLE_PREFIX . "style");
		while ($style_row = $this->db->fetch_array($style_result))
		{
			$skipstyleids .= ',' . intval($style_row['styleid']);
		}
		$this->db->query_write("DELETE FROM " . TABLE_PREFIX . "stylevar WHERE styleid NOT IN($skipstyleids)");

		$orphaned_stylevar_count = $this->db->affected_rows();
		if ($orphaned_stylevar_count > 0)
		{
			$this->show_message(sprintf($this->phrase['version']['404']['removed_x_orphaned_stylevars'], $orphaned_stylevar_count));
		}
		else
		{
			$this->show_message($this->phrase['version']['404']['no_orphaned_stylevars']);
		}
	}

	public function step_3()
	{
		$smilies_to_change = array(
			'smile', 'redface', 'biggrin', 'wink', 'tongue', 'cool',
			'rolleyes', 'mad', 'eek', 'confused', 'frown'
		);

		//change the standard icons to the new png images.
		$i = 0;
		foreach ($smilies_to_change as $smilie)
		{
			$i++;
			$this->run_query(
				sprintf($this->phrase['version']['404']['update_smilie'], $i, count($smilies_to_change)),
				"UPDATE " . TABLE_PREFIX . "smilie SET smiliepath = 'images/smilies/$smilie.png'
				WHERE smiliepath = 'images/smilies/$smilie.gif' AND imagecategoryid = 1"
			);
		}
	}

	public function step_4()
	{
		require_once(DIR . '/includes/adminfunctions.php');
		build_image_cache('smilie');

		$this->drop_field(
			sprintf($this->phrase['core']['altering_x_table'], 'usergroup', 1, 1),
			'usergroup',
			'albumpicmaxsize'
		);
	}

	public function step_5()
	{
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'usertitle', 1, 1),
			"ALTER TABLE " . TABLE_PREFIX . "usertitle CHANGE usertitleid usertitleid INT UNSIGNED NOT NULL AUTO_INCREMENT"
		);
	}

	public function step_6()
	{
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'album', 1, 1),
			"ALTER TABLE " . TABLE_PREFIX . "album CHANGE description description MEDIUMTEXT"
		);
	}

	/**
	* Step #7 - The default on this field is not relevant since this value is determined at user creation but let's match what mysql-schema has
	*
	*/
	public function step_7()
	{
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'user', 1, 1),
			"ALTER TABLE " . TABLE_PREFIX . "user CHANGE options options INT UNSIGNED NOT NULL DEFAULT '167788559'"
		);
	}

	public function step_8()
	{
		$this->drop_index(
			sprintf($this->phrase['core']['altering_x_table'], 'contenttype', 1, 4),
			'contenttype',
			'package'
		);
	}

	public function step_9()
	{
		$this->drop_index(
			sprintf($this->phrase['core']['altering_x_table'], 'contenttype', 2, 4),
			'contenttype',
			'packageclass'
		);
	}

	public function step_10()
	{
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'contenttype', 3, 4),
			'contenttype',
			'packageclass',
			array('packageid', 'class'),
			'unique'
		);
	}

	public function step_11()
	{
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'contenttype', 4, 4),
				"ALTER TABLE " . TABLE_PREFIX . "contenttype ENGINE={$this->hightrafficengine}"
		);
	}

	public function step_12()
	{
		$this->drop_index(
			sprintf($this->phrase['core']['altering_x_table'], 'prefixpermission', 1, 3),
			'prefixpermission',
			'prefixsetid'
		);
	}

	public function step_13()
	{
		$this->drop_index(
			sprintf($this->phrase['core']['altering_x_table'], 'prefixpermission', 2, 3),
			'prefixpermission',
			'prefixusergroup'
		);
	}

	public function step_14()
	{
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'prefixpermission', 3, 3),
			'prefixpermission',
			'prefixsetid',
			array('prefixid', 'usergroupid')
		);
	}

	public function step_15()
	{
		$this->drop_index(
			sprintf($this->phrase['core']['altering_x_table'], 'groupmessage', 1, 2),
			'groupmessage',
			'postuserid'
		);
	}

	public function step_16()
	{
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'groupmessage', 2, 2),
			'groupmessage',
			'postuserid',
			array('postuserid', 'discussionid', 'state')
		);
	}

	public function step_17()
	{
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'editlog', 1, 1),
				"ALTER TABLE " . TABLE_PREFIX . "editlog CHANGE hashistory hashistory SMALLINT UNSIGNED NOT NULL DEFAULT '0'"
		);
	}

	public function step_18()
	{
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'profilevisitor', 1, 1),
				"ALTER TABLE " . TABLE_PREFIX . "profilevisitor CHANGE visible visible SMALLINT UNSIGNED NOT NULL DEFAULT '1'"
		);
	}

	public function step_19()
	{
		$this->drop_index(
			sprintf($this->phrase['core']['altering_x_table'], 'groupmessage', 1, 1),
			'groupmessage',
			'gm_ft'
		);

		$this->long_next_step();
	}

	public function step_20()
	{
		$this->drop_index(
			sprintf($this->phrase['core']['altering_x_table'], 'socialgroup', 1, 1),
			'socialgroup',
			'name'
		);

		$this->long_next_step();
	}

	public function step_21()
	{
		$this->skip_message();
	}

	/**
	 * Step #22 - Set viewattachedimages = 3 when we had thumbnails disabled and view full images enabled
	 */
	public function step_22()
	{
		//the attach thumbs options has been removed, but probably still exists if we're hitting this
		//point in the upgrade from vB4.  If we're rerunning this step after upgrading to vB5
		//(and I can't think of any scenario where doing that with a step this old would be a good idea)
		//this just skip this update.  It's not clear what we'd want to do and the admin can always
		//fix the config manually in this case.
		if (
			isset($this->registry->options['attachthumbs']) AND
			!$this->registry->options['attachthumbs'] AND
			$this->registry->options['viewattachedimages'] == 1
		)
		{
			$this->run_query(
				sprintf($this->phrase['core']['altering_x_table'], 'setting', 1, 1),
					"UPDATE " . TABLE_PREFIX . "setting SET value = 3 WHERE varname = 'viewattachedimages'"
			);
		}
		else
		{
			$this->skip_message();
		}
	}

	/**
	* Step #23 - add the facebook name to the user table
	*
	*/
	public function step_23()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'user', 1, 2),
			'user',
			'fbaccesstoken',
			'VARCHAR',
			array(
				'length' => 255
			)
		);
	}

	/**
	* Step #24 - add the facebook profilepic to the user table
	*
	*/
	public function step_24()
	{
		//this field was removed in 407.  Not much point in adding it here.
		$this->skip_message();
	}

	/*
	* Step #25 Removed, its not required for upgrading to vB5
	*/
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
