<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_400rc2 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->add_index(
			sprintf($this->phrase['core']['create_index_x_on_y'], 'user_activity', TABLE_PREFIX . 'session'),
			'session',
			'user_activity',
			array('userid', 'lastactivity')
		);
	}

	public function step_2()
	{
		$this->add_index(
			sprintf($this->phrase['core']['create_index_x_on_y'], 'guest_lookup', TABLE_PREFIX . 'session'),
			'session',
			'guest_lookup',
			array('idhash', 'host', 'userid')
		);
	}

	public function step_3()
	{
		$this->add_index(
			sprintf($this->phrase['core']['create_index_x_on_y'], 'styleid', TABLE_PREFIX . 'template'),
			'template',
			'styleid',
			array('styleid')
		);
	}

	public function step_4()
	{
		$profile_field_category_locations = array(
			'profile_left_first'  => 'profile_tabs_first',
			'profile_left_last'   => 'profile_tabs_last',
			'profile_right_first' => 'profile_sidebar_first',
			'profile_right_mini'  => 'profile_sidebar_stats',
			'profile_right_album' => 'profile_sidebar_albums',
			'profile_right_last'  => 'profile_sidebar_last',
		);

		foreach ($profile_field_category_locations AS $old_category_location => $new_category_location)
		{
			$this->run_query(
				$this->phrase['version']['400rc2']['updating_profile_field_category_data'],
				"UPDATE " . TABLE_PREFIX . "profilefieldcategory
					SET location = '$new_category_location'
					WHERE location = '$old_category_location'"
			);
		}
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
