<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_400rc1 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . 'block'),
			"CREATE TABLE " . TABLE_PREFIX . "block (
				blockid INT UNSIGNED NOT NULL AUTO_INCREMENT,
				blocktypeid INT NOT NULL DEFAULT '0',
				title VARCHAR(255) NOT NULL DEFAULT '',
				description MEDIUMTEXT,
				url VARCHAR(100) NOT NULL DEFAULT '',
				cachettl INT NOT NULL DEFAULT '0',
				displayorder SMALLINT NOT NULL DEFAULT '0',
				active SMALLINT NOT NULL DEFAULT '0',
				configcache MEDIUMBLOB,
				PRIMARY KEY (blockid),
				KEY blocktypeid (blocktypeid)
			)",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}

	public function step_2()
	{
		$this->skip_message();
	}

	public function step_3()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . 'blocktype'),
			"CREATE TABLE " . TABLE_PREFIX . "blocktype (
				blocktypeid INT UNSIGNED NOT NULL AUTO_INCREMENT,
				productid VARCHAR(25) NOT NULL DEFAULT '',
				name VARCHAR(50) NOT NULL DEFAULT '',
				title VARCHAR(255) NOT NULL DEFAULT '',
				description MEDIUMTEXT,
				allowcache TINYINT NOT NULL DEFAULT '0',
				PRIMARY KEY (blocktypeid),
				UNIQUE KEY (name),
				KEY productid (productid)
			)",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}

	/**
	* Step #4 - New phrase types
	*
	*/
	public function step_4()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'language', 1, 1),
			'language',
			'phrasegroup_vbblock',
			'mediumtext',
			self::FIELD_DEFAULTS
		);
	}

	public function step_5()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'language', 1, 1),
			'language',
			'phrasegroup_vbblocksettings',
			'mediumtext',
			self::FIELD_DEFAULTS
		);
	}

	public function step_6()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . "phrasetype"),
			"INSERT IGNORE INTO " . TABLE_PREFIX . "phrasetype
				(title, editrows, fieldname, special)
			VALUES
				('{$this->phrase['phrasetype']['vbblock']}', 3, 'vbblock', 0),
				('{$this->phrase['phrasetype']['vbblocksettings']}', 3, 'vbblocksettings', 0)
			"
		);
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
