<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_400b4 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . "ad"),
			"CREATE TABLE " . TABLE_PREFIX . "ad (
				adid INT UNSIGNED NOT NULL auto_increment,
				title VARCHAR(250) NOT NULL DEFAULT '',
				adlocation VARCHAR(250) NOT NULL DEFAULT '',
				displayorder INT UNSIGNED NOT NULL DEFAULT '0',
				active SMALLINT UNSIGNED NOT NULL DEFAULT '0',
				snippet MEDIUMTEXT,
				PRIMARY KEY (adid),
				KEY active (active)
			)",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}

	public function step_2()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . "adcriteria"),
			"CREATE TABLE " . TABLE_PREFIX . "adcriteria (
				adid INT UNSIGNED NOT NULL DEFAULT '0',
				criteriaid VARCHAR(191) NOT NULL DEFAULT '',
				condition1 VARCHAR(250) NOT NULL DEFAULT '',
				condition2 VARCHAR(250) NOT NULL DEFAULT '',
				condition3 VARCHAR(250) NOT NULL DEFAULT '',
				PRIMARY KEY (adid,criteriaid)
			)
			",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}

	public function step_3()
	{
		if (!$this->field_exists('language', 'phrasegroup_advertising'))
		{
			$this->run_query(
				sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . "advertising"),
				"ALTER TABLE " . TABLE_PREFIX . "language ADD phrasegroup_advertising mediumtext not null"
			);
		}
		else
		{
			$this->skip_message();
		}
	}

	public function step_4()
	{
		if (!$this->db->query_first("SELECT * FROM " . TABLE_PREFIX . "phrasetype WHERE fieldname = 'advertising'"))
		{
			$this->run_query(
				sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . "phrasetype"),
				"INSERT INTO " . TABLE_PREFIX . "phrasetype
				VALUES
					('advertising', 'Advertising', 3, '', 0)
				"
			);
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
