<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_400b3 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->show_message($this->phrase['core']['updating_bbcode']);
		require_once(DIR . '/includes/functions_databuild.php');
		//a user must be logged in to compile bbcode template
		vB_Upgrade::createAdminSession();
		build_bbcode_video();
	}

	/**
	* Step #2 - retire existing styles
	*
	*/
	public function step_2()
	{
		$this->run_query(
			$this->phrase['version']['400b3']['updating_styles'],
			"UPDATE " . TABLE_PREFIX . "style
			SET userselect = 0,
				displayorder = 65432,
			    title =
			    	IF(title LIKE '%" . $this->db->escape_string_like($this->phrase['version']['400b3']['incompatible']) . "',
			    	title,
			    	CONCAT(title, '" . $this->db->escape_string($this->phrase['version']['400b3']['incompatible']) . "'))
		");
	}

	/**
	* Step #3 - disassociate styles with forums
	*
	*/
	public function step_3()
	{
		$this->run_query(
			$this->phrase['version']['400b3']['updating_forum_styles'],
			"UPDATE " . TABLE_PREFIX . "forum
			SET styleid = 0
		");
	}

	/**
	* Step #4 - clear user style preferences
	*
	*/
	public function step_4()
	{
		$this->run_query(
			$this->phrase['version']['400b3']['updating_user_styles'],
			"UPDATE " . TABLE_PREFIX . "user
			SET styleid = 0
		");
	}

	/**
	* Step #5 - clear blog style
	*
	*/
	public function step_5()
	{
		$this->run_query(
			$this->phrase['version']['400b3']['updating_blog_styles'],
			"UPDATE " . TABLE_PREFIX . "setting
			SET value = '0'
			WHERE varname = 'vbblog_style'
		");
	}

	/**
	* Step #6 - Create new style
	*/
	public function step_6()
	{
		$this->skip_message(); // Not required for vB5 update
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
