<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/


class vB_Upgrade_400b1 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->drop_index(
			sprintf($this->phrase['core']['altering_x_table'], 'attachment', 1, 2),
			'attachment',
			'contenttypeid'
		);
	}

	public function step_2()
	{
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'attachment', 2, 2),
			'attachment',
			'contenttypeid',
			array('contenttypeid', 'contentid', 'attachmentid')
		);
	}

	public function step_3()
	{
		$row = $this->db->query_first("
			SELECT COUNT(*) AS count FROM " . TABLE_PREFIX . "notice WHERE title = 'default_guest_message'
		");

		if ($row['count'] == 0)
		{
			$this->show_message('Adding a notice');

			$data = array(
				'title' => 'default_guest_message',
				'text' => $this->phrase['install']['default_guest_message'],
				'displayorder' => 10,
				'active' => 1,
				'persistent' => 1,
				'dismissible' => 1,
				'criteria' => array('in_usergroup_x' => array('condition1' => 1)),
			);
			vB_Library::instance('notice')->save($data);
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
