<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_386 extends vB_Upgrade_Version
{
	public function step_1()
	{
		//Update Admins and Super Mods to have the "canignorequota" perm in case they don't have it...
		//This is the value for bf_ugp_pmpermissions['canignorequota'] but rather than relying
		//on the system being sufficiently functional at this point to load it from the DB we'll
		//hardcode it.  Even if it for some reason changed any DB we'd be upgrading is going to be
		//expecting it be the old value anyway.
		$canignorequotaperm = 4;
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'usergroup', 1, 1),
			"UPDATE " . TABLE_PREFIX . "usergroup
			SET pmpermissions = pmpermissions + $canignorequotaperm
			WHERE usergroupid IN (5, 6) AND NOT (pmpermissions & $canignorequotaperm)
		");
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
