<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_370rc3 extends vB_Upgrade_Version
{
	/**
	* Step #1 - give all admins notices permissions by default
	*
	*/
	public function step_1()
	{
		if (!isset($this->registry->bf_ugp_adminpermissions['canadminnotices']))
		{
			$this->add_error($this->phrase['core']['wrong_bitfield_xml'], self::PHP_TRIGGER_ERROR, true);
		}

		$this->run_query(
			sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . 'administrator'),
			"UPDATE " . TABLE_PREFIX . "administrator SET
				adminpermissions = adminpermissions | " .
					($this->registry->bf_ugp_adminpermissions['canadminnotices'] + $this->registry->bf_ugp_adminpermissions['canadminmodlog'])
		);

		require_once(DIR . '/includes/functions_databuild.php');
		build_birthdays();
	}

	public function step_2()
	{
		$tables = $this->db->query_write("SHOW TABLES");
		$skip = true;
		while ($table = $this->db->fetch_array($tables, vB_Database::DBARRAY_NUM))
		{
			if (strpos($table[0], TABLE_PREFIX . 'aaggregate_temp_') !== false OR strpos($table[0], TABLE_PREFIX . 'taggregate_temp_') !== false)
			{
				if (!preg_match('/_(\d+)$/siU', $table[0], $matches))
				{
					continue;
				}

				if ($matches[1] > TIMENOW - 3600)
				{
					continue;
				}

				$skip = false;
				$this->run_query(
					sprintf($this->phrase['core']['dropping_old_table_x'], $table[0]),
					"DROP TABLE IF EXISTS " . $table[0]
				);
			}
		}

		if ($skip)
		{
			$this->skip_message();
		}
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
