<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_366 extends vB_Upgrade_Version
{
	public function step_1()
	{
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'avatar', 1, 1),
			"ALTER TABLE " . TABLE_PREFIX . "avatar CHANGE minimumposts minimumposts INT UNSIGNED NOT NULL DEFAULT '0'"
		);
	}

	public function step_2()
	{
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'ranks', 1, 1),
			"ALTER TABLE " . TABLE_PREFIX . "`ranks` CHANGE minposts minposts INT UNSIGNED NOT NULL DEFAULT '0'"
		);
	}

	public function step_3()
	{
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'usertitle', 1, 1),
			"ALTER TABLE " . TABLE_PREFIX . "usertitle CHANGE minposts minposts INT UNSIGNED NOT NULL DEFAULT '0'"
		);
	}

	public function step_4()
	{
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'calendar', 1, 1),
			"ALTER TABLE " . TABLE_PREFIX . "calendar CHANGE neweventemail neweventemail TEXT"
		);
	}

	public function step_5()
	{
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'forum', 1, 2),
			"ALTER TABLE " . TABLE_PREFIX . "forum CHANGE newpostemail newpostemail TEXT"
		);
	}

	public function step_6()
	{
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'forum', 2, 2),
			"ALTER TABLE " . TABLE_PREFIX . "forum CHANGE newthreademail newthreademail TEXT"
		);
	}

	public function step_7()
	{
		$this->run_query(
			sprintf($this->phrase['core']['altering_x_table'], 'datastore', 1, 1),
			"ALTER TABLE " . TABLE_PREFIX . "datastore CHANGE title title VARCHAR(50) NOT NULL DEFAULT ''"
		);
	}

	public function step_8()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . "userlist"),
			"CREATE TABLE " . TABLE_PREFIX . "userlist (
				userid INT UNSIGNED NOT NULL DEFAULT '0',
				relationid INT UNSIGNED NOT NULL DEFAULT '0',
				type ENUM('buddy', 'ignore') NOT NULL DEFAULT 'buddy',
				PRIMARY KEY (userid, relationid, type),
				KEY userid (relationid)
			)",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}

	public function step_9()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . "profilefieldcategory"),
			"CREATE TABLE " . TABLE_PREFIX . "profilefieldcategory (
				profilefieldcategoryid SMALLINT UNSIGNED NOT NULL AUTO_INCREMENT,
				displayorder SMALLINT UNSIGNED NOT NULL,
				PRIMARY KEY (profilefieldcategoryid)
			)",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}

	public function step_10()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'profilefield', 1, 2),
			'profilefield',
			'profilefieldcategoryid',
			'smallint',
			self::FIELD_DEFAULTS
		);
	}

	public function step_11()
	{
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'profilefield', 2, 2),
			'profilefield',
			'profilefieldcategoryid',
			'profilefieldcategoryid'
		);
	}

	public function step_12()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'externalcache', 1, 2),
			'externalcache',
			'forumid',
			'int',
			self::FIELD_DEFAULTS
		);
	}

	public function step_13()
	{
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'externalcache', 2, 2),
			'externalcache',
			'forumid',
			'forumid'
		);
	}

	public function step_14()
	{
		$this->drop_index(
			sprintf($this->phrase['core']['altering_x_table'], 'template', 1, 2),
			'template',
			'title'
		);
	}

	public function step_15()
	{
		$skip = true;
		/* this deals with the older templates */
		$badtemplates = $this->db->query_read("
			SELECT styleid, title, templatetype, MAX(dateline) AS newest, COUNT(*) AS total
			FROM " . TABLE_PREFIX . "template
			GROUP BY styleid, title, templatetype
			HAVING total > 1
		");
		while ($template = $this->db->fetch_array($badtemplates))
		{
			$skip = false;
			$this->run_query(
				sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . "user"),
				"DELETE FROM " . TABLE_PREFIX . "template
				WHERE styleid = $template[styleid]
					AND title = '" . $this->db->escape_string($template['title']) . "'
					AND templatetype = '" . $this->db->escape_string($template['templatetype']) . "'
					AND dateline < " . intval($template['newest'])
			);
		}
		if ($skip)
		{
			$this->skip_message();
		}
	}

	public function step_16()
	{
		$skip = true;
		/* now to deal with those that have the same date */
		$badtemplates = $this->db->query_read("
			SELECT styleid, title, templatetype, MAX(templateid) AS newest, COUNT(*) AS total
			FROM " . TABLE_PREFIX . "template
			GROUP BY styleid, title, templatetype
			HAVING total > 1
		");
		while ($template = $this->db->fetch_array($badtemplates))
		{
			$this->run_query(
				sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . "user"),
				"DELETE FROM " . TABLE_PREFIX . "template
				WHERE styleid = $template[styleid]
					AND title = '" . $this->db->escape_string($template['title']) . "'
					AND templatetype = '" . $this->db->escape_string($template['templatetype']) . "'
					AND templateid <> " . intval($template['newest'])
			);
			$skip = false;
		}
		if ($skip)
		{
			$this->skip_message();
		}
	}

	public function step_17()
	{
		$this->add_index(
			sprintf($this->phrase['core']['altering_x_table'], 'template', 2, 2),
			'template',
			'title',
			array('title', 'styleid', 'templatetype'),
			'unique'
		);
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112185 $
|| #######################################################################
\*=========================================================================*/
