<?php
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

class vB_Upgrade_361 extends vB_Upgrade_Version
{
	public function step_1()
	{
		if (!$this->field_exists('infractionlevel', 'extend'))
		{
			$avatarids = array();
			$avatars = $this->db->query_read("
				SELECT userid
				FROM " . TABLE_PREFIX . "customavatar
			");
			while ($avatar = $this->db->fetch_array($avatars))
			{
				$avatarids[] = $avatar['userid'];
			}

			if ($avatarids)
			{
				$adminAvtOpt = 0;
				if (!empty($this->registry->bf_misc_adminoptions['adminavatar']))
				{
					$adminAvtOpt = $this->registry->bf_misc_adminoptions['adminavatar'];
				}
				$this->run_query(
					sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . "user"),
					"UPDATE " . TABLE_PREFIX . "user
					SET adminoptions = adminoptions | " . $adminAvtOpt . "
					WHERE userid IN (" . implode(',', $avatarids) . ")"
				);
			}

			if (!$avatarids)
			{
				$this->skip_message();
			}
		}
		else
		{
			$this->skip_message();
		}
	}

	public function step_2()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'infractionlevel', 1, 1),
			'infractionlevel',
			'extend',
			'smallint',
			self::FIELD_DEFAULTS
		);
	}

	public function step_3()
	{
		if (!$this->field_exists('podcastitem', 'explicit'))
		{
			$this->add_field(
				sprintf($this->phrase['core']['altering_x_table'], 'podcasturl', 1, 4),
				'podcasturl',
				'explicit',
				'smallint',
				self::FIELD_DEFAULTS
			);
		}
		else
		{
			$this->skip_message();
		}
	}

	public function step_4()
	{
		if (!$this->field_exists('podcastitem', 'explicit'))
		{
			$this->add_field(
				sprintf($this->phrase['core']['altering_x_table'], 'podcasturl', 2, 4),
				'podcasturl',
				'keywords',
				'varchar',
				array('length' => 255, 'attributes' => self::FIELD_DEFAULTS)
			);
		}
		else
		{
			$this->skip_message();
		}
	}

	public function step_5()
	{
		if (!$this->field_exists('podcastitem', 'explicit'))
		{
			$this->add_field(
				sprintf($this->phrase['core']['altering_x_table'], 'podcasturl', 3, 4),
				'podcasturl',
				'subtitle',
				'varchar',
				array('length' => 255, 'attributes' => self::FIELD_DEFAULTS)
			);
		}
		else
		{
			$this->skip_message();
		}
	}

	public function step_6()
	{
		if (!$this->field_exists('podcastitem', 'explicit'))
		{
			$this->add_field(
				sprintf($this->phrase['core']['altering_x_table'], 'podcasturl', 4, 4),
				'podcasturl',
				'author',
				'varchar',
				array('length' => 255, 'attributes' => self::FIELD_DEFAULTS)
			);
		}
		else
		{
			$this->skip_message();
		}
	}

	public function step_7()
	{
		if (!$this->field_exists('podcastitem', 'explicit'))
		{
			$this->run_query(
				 sprintf($this->phrase['version']['361']['rename_podcasturl'], TABLE_PREFIX),
				 "ALTER TABLE " . TABLE_PREFIX . "podcasturl RENAME " . TABLE_PREFIX . "podcastitem",
				 self::MYSQL_ERROR_TABLE_MISSING
			);
		}
		else
		{
			$this->skip_message();
		}
	}

	public function step_8()
	{
		$this->add_field(
			sprintf($this->phrase['core']['altering_x_table'], 'administrator', 1, 1),
			'administrator',
			'dismissednews',
			'text',
			self::FIELD_DEFAULTS
		);
	}

	public function step_9()
	{
		$this->run_query(
			sprintf($this->phrase['vbphrase']['create_table'], TABLE_PREFIX . "infractionban"),
			"CREATE TABLE " . TABLE_PREFIX . "infractionban (
				infractionbanid int unsigned NOT NULL auto_increment,
				usergroupid int NOT NULL DEFAULT '0',
				banusergroupid int unsigned NOT NULL DEFAULT '0',
				amount int unsigned NOT NULL DEFAULT '0',
				period char(5) NOT NULL DEFAULT '',
				method enum('points','infractions') NOT NULL default 'infractions',
				PRIMARY KEY (infractionbanid),
				KEY usergroupid (usergroupid)
			)",
			self::MYSQL_ERROR_TABLE_EXISTS
		);
	}

	public function step_10()
	{
		$changed_strip = false;

		if (strpos($this->registry->options['blankasciistrip'], 'u8204') === false)
		{
			$this->registry->options['blankasciistrip'] .= ' u8204 u8205';
			$changed_strip = true;
		}
		if (strpos($this->registry->options['blankasciistrip'], 'u8237') === false)
		{
			$this->registry->options['blankasciistrip'] .= ' u8237 u8238';
			$changed_strip = true;
		}

		if ($changed_strip)
		{
			$this->run_query(
				sprintf($this->phrase['vbphrase']['update_table'], TABLE_PREFIX . "setting"),
				"UPDATE " . TABLE_PREFIX . "setting SET
					value = '" . $this->db->escape_string($this->registry->options['blankasciistrip']) . "'
				WHERE varname = 'blankasciistrip'"
			);
		}
		else
		{
			$this->skip_message();
		}
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 112203 $
|| #######################################################################
\*=========================================================================*/
