<?php if (!defined('VB_ENTRY')) die('Access denied.');
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

// ###################### Start do login redirect #######################
function do_login_redirect()
{
	global $vbulletin, $vbphrase;

	$vbulletin->input->fetch_basepath();

	if (
		preg_match('#login.php(?:\?|$)#', $vbulletin->url)
		OR strpos($vbulletin->url, 'do=logout') !== false
		OR (!$vbulletin->options['allowmultiregs'] AND strpos($vbulletin->url, $vbulletin->basepath . 'register.php') === 0)
	)
	{
		$forumHome = vB_Library::instance('content_channel')->getForumHomeChannel();
		$vbulletin->url = vB5_Route::buildUrl($forumHome['routeid'] . '|fullurl');
	}
	else
	{
		$vbulletin->url = addslashes($vbulletin->url );
		$vbulletin->url = preg_replace('#^/+#', '/', $vbulletin->url); // bug 3654 don't ask why
	}

	$temp = strpos($vbulletin->url, '?');
	if ($temp)
	{
		$formfile = substr($vbulletin->url, 0, $temp);
	}
	else
	{
		$formfile =& $vbulletin->url;
	}

	$postvars = $vbulletin->GPC['postvars'];


	// recache the global group to get the stuff from the new language
	$globalgroup = $vbulletin->db->query_first_slave("
		SELECT phrasegroup_global, languagecode, charset
		FROM " . TABLE_PREFIX . "language
		WHERE languageid = " . intval($vbulletin->userinfo['languageid'] ? $vbulletin->userinfo['languageid'] : $vbulletin->options['languageid'])
	);
	if ($globalgroup)
	{
		$vbphrase = array_merge($vbphrase, unserialize($globalgroup['phrasegroup_global']));
		if (vB_Template_Runtime::fetchStyleVar('charset') != $globalgroup['charset'])
		{
			// change the character set in a bunch of places - a total hack
			global $headinclude;

			$headinclude = str_replace(
				"content=\"text/html; charset=" . vB_Template_Runtime::fetchStyleVar('charset') . "\"",
				"content=\"text/html; charset=$globalgroup[charset]\"",
				$headinclude
			);

			vB_Template_Runtime::addStyleVar('charset', $globalgroup['charset'], 'imgdir');
			$vbulletin->userinfo['lang_charset'] = $globalgroup['charset'];

			exec_headers();
		}

		if ($vbulletin->GPC['postvars'])
		{
			$postvars = array();
			$client_string = verify_client_string($vbulletin->GPC['postvars']);
			if ($client_string)
			{
				$postvars = @json_decode($client_string, true);
			}

			if (($postvars['securitytoken'] ?? '') == 'guest')
			{
				$vbulletin->userinfo['securitytoken_raw'] = sha1($vbulletin->userinfo['userid'] . sha1($vbulletin->userinfo['secret']) . sha1(vB_Request_Web::$COOKIE_SALT));
				$vbulletin->userinfo['securitytoken'] = TIMENOW . '-' . sha1(TIMENOW . $vbulletin->userinfo['securitytoken_raw']);
				$postvars['securitytoken'] = $vbulletin->userinfo['securitytoken'];
				$vbulletin->GPC['postvars'] = sign_client_string(json_encode($postvars));
			}
		}

		vB_Template_Runtime::addStyleVar('languagecode', $globalgroup['languagecode']);
	}

	//this is only called for the cp login anymore.  And the other redirect branch had bad code.
	//so we'll just issue the cp redirect and call it a day.
	require_once(DIR . '/includes/adminfunctions.php');
	print_cp_redirect(create_full_url($vbulletin->url));
}

/**
* Sends the appropriate HTTP headers for the page that is being displayed
*
* @param	boolean	If true, send HTTP 200
* @param	boolean	If true, send no-cache headers
*/
//this used to be a general function but is now only used by do_login_redirect
function exec_headers($headers = true, $nocache = true)
{
	global $vbulletin;
	$options = vB::getDatastore()->getValue('options');
	$contenttype = 'text/html';

	$langcharset = $vbulletin->userinfo['lang_charset'];

	$sendcontent = true;
	if ($options['addheaders'] AND !$vbulletin->noheader AND $headers)
	{
		http_response_code(200);
		@header('Content-Type: ' . $contenttype . ($langcharset != '' ? '; charset=' . $langcharset : ''));
		$sendcontent = false;
	}

	if ($options['nocacheheaders'] AND !$vbulletin->noheader AND $nocache)
	{
		// no caching
		exec_nocache_headers($sendcontent);
	}
	else if (!$vbulletin->noheader)
	{
		@header("Cache-Control: private");
		@header("Pragma: private");
		if ($sendcontent)
		{
			$charset = ($langcharset ? $langcharset : vB_Template_Runtime::fetchStyleVar('charset'));
			@header('Content-Type: ' . $contenttype . '; charset=' . $charset);
		}
	}
}

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 113983 $
|| #######################################################################
\*=========================================================================*/
