<?php if (!defined('VB_ENTRY')) die('Access denied.');
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(error_reporting() & ~E_NOTICE);

// ########################## REQUIRE BACK-END ############################
require_once(DIR . '/includes/class_paid_subscription.php');

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################
$subobj = new vB_PaidSubscription();
$subobj->cache_user_subscriptions();

if (is_array($subobj->subscriptioncache))
{
	$assertor = vB::getDbAssertor();

	foreach ($subobj->subscriptioncache as $key => $subscription)
	{
		// disable people :)
		$subscribers = $assertor->assertQuery('vBForum:subscriptionlog', [
			vB_dB_Query::CONDITIONS_KEY=> [
				['field'=>'subscriptionid', 'value' => $subscription['subscriptionid'], vB_dB_Query::OPERATOR_KEY => vB_dB_Query::OPERATOR_EQ],
				['field'=>'expirydate',     'value' => vB::getRequest()->getTimeNow(),  vB_dB_Query::OPERATOR_KEY => vB_dB_Query::OPERATOR_LTE],
				['field'=>'status',         'value' => 1,                               vB_dB_Query::OPERATOR_KEY => vB_dB_Query::OPERATOR_EQ],
			]
		]);
		foreach ($subscribers as $subscriber)
		{
			$subobj->delete_user_subscription($subscription['subscriptionid'], $subscriber['userid'], -1, true);
		}
	}

	// time for the reminders
	$subscriptions_reminders = $assertor->assertQuery('getSubscriptionsReminders', [
		'time1' => vB::getRequest()->getTimeNow() + (86400 * 2),
		'time2' => vB::getRequest()->getTimeNow() + (86400 * 3)
	]);

	vB_Mail::vbmailStart();

	$string = vB::getString();
	$datastore = vB::getDatastore();
	$bbtitle = $datastore->getOption('bbtitle');
	$bbtitle_escaped = $string->htmlspecialchars($bbtitle);
	$frontendurl = $datastore->getOption('frontendurl');

	$suburl = vB5_Route::buildUrl('settings|fullurl', ['tab' => 'subscriptions']);
	foreach ($subscriptions_reminders as $subscriptions_reminder)
	{
		$phraseAux = vB_Api::instanceInternal('phrase')->fetch(['sub' . $subscriptions_reminder['subscriptionid'] . '_title', 'subscription']);
		$subscription_title = $phraseAux['sub' . $subscriptions_reminder['subscriptionid'] . '_title'];
		// Not sure about this one. When testing it, if it had HTML, the frontend would render it as HTML.
		// Email would not, because it was text/plain previously. Normally I'd just escape it, but since the frontend renders it w/ HTML,
		// I'm skipping the escape for this...
		// $subscription_title = $string->htmlspecialchars($subscription_title);
		$displayname_safe = $string->htmlspecialchars($subscriptions_reminder['displayname']);

		$maildata = vB_Api::instanceInternal('phrase')->fetchEmailPhrases(
			'paidsubscription_reminder',
			[
				$displayname_safe,
				$subscription_title,
				$suburl,
				$bbtitle_escaped,
			],
			[],
			$subscriptions_reminder['languageid']
		);
		vB_Mail::vbmail2($subscriptions_reminder['email'], $maildata['subject'], $maildata['message']);
	}
	vB_Mail::vbmailEnd();

	// Legacy Hook 'cron_script_subscriptions' Removed //
}

log_cron_action('', $nextitem, 1);

/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 109371 $
|| #######################################################################
\*=========================================================================*/
