<?php if (!defined('VB_ENTRY')) die('Access denied.');
/*========================================================================*\
|| ###################################################################### ||
|| # vBulletin 5.7.5 Patch Level 3 - Licence Number LD9934D570
|| # ------------------------------------------------------------------ # ||
|| # Copyright 2000-2025 MH Sub I, LLC dba vBulletin. All Rights Reserved.  # ||
|| # This file may not be redistributed in whole or significant part.   # ||
|| # ----------------- VBULLETIN IS NOT FREE SOFTWARE ----------------- # ||
|| # http://www.vbulletin.com | http://www.vbulletin.com/license.html   # ||
|| ###################################################################### ||
\*========================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(error_reporting() & ~E_NOTICE);

// ########################################################################
// ######################### START MAIN SCRIPT ############################
// ########################################################################

$datastore = vB::getDatastore();
$vboptions = $datastore->getValue('options');
$string = vB::getString();
$bbtitle_escaped = $string->htmlspecialchars($vboptions['bbtitle']);

if($vboptions['enablebirthdayemails'])
{
	$bf_misc_useroptions = $datastore->getValue('bf_misc_useroptions');
	$bf_ugp_genericoptions = $datastore->getValue('bf_ugp_genericoptions');
	$usergroupcache = $datastore->getValue('usergroupcache');

	$ids = [];
	foreach($usergroupcache AS $usergroupid => $usergroup)
	{
		if (
			$usergroup['genericoptions'] & $bf_ugp_genericoptions['showbirthday'] AND
			$usergroup['genericoptions'] & $bf_ugp_genericoptions['isnotbannedgroup'] AND
			!in_array($usergroup['usergroupid'], [1, 3, 4])
		)
		{
			$ids[] = $usergroupid;
		}
	}

	if($ids)
	{
		$now = vB::getRequest()->getTimeNow();
		$today = date('m-d', $now);

		$conditions = [
			'usergroupid' => $ids,
			['field' => 'options', 'value' => $bf_misc_useroptions['adminemail'], 'operator' =>  vB_dB_Query::OPERATOR_AND],
			['field' => 'options', 'value' => $bf_misc_useroptions['birthdayemail'], 'operator' =>  vB_dB_Query::OPERATOR_AND],
			['field' => 'birthday', 'value' => $today . '-', 'operator' =>  vB_dB_Query::OPERATOR_BEGINS],
		];

		if ($vboptions['birthdayemaillookback'])
		{
			$cutoff = $now - ($vboptions['birthdayemaillookback'] * 86400);
			$conditions[] = ['field' => 'lastvisit', 'value' => $cutoff . '-', 'operator' => vB_dB_Query::OPERATOR_GT];
		}

		$birthdays = vB::getDbAssertor()->select('user', $conditions, false, ['username', 'displayname', 'email', 'languageid']);

		$usersEmailed = [];
		vB_Mail::vbmailStart();
		foreach ($birthdays AS $userinfo)
		{
			$displayname_safe = $string->htmlspecialchars($userinfo['displayname']);
			$maildata = vB_Api::instanceInternal('phrase')->fetchEmailPhrases(
				// todo: add unsubscribe link to this email
				'birthday',
				[
					$displayname_safe,
					$bbtitle_escaped,
				],
				[$vboptions['bbtitle']],
				$userinfo['languageid']
			);

			vB_Mail::vbmail2($userinfo['email'], $maildata['subject'], $maildata['message']);
			$usersEmailed[] = $userinfo['username'];
		}
		vB_Mail::vbmailEnd();

		if ($usersEmailed)
		{
			log_cron_action(implode(', ', $usersEmailed), $nextitem, 1);
		}
	}
}
/*=========================================================================*\
|| #######################################################################
|| # Downloaded: 04:56, Fri Sep 12th 2025
|| # CVS: $RCSfile$ - $Revision: 109371 $
|| #######################################################################
\*=========================================================================*/
