<?php
define('MBQ_PROTOCOL','web');
global $tapatalk_cmd;
$tapatalk_cmd = 'update';
define('IN_MOBIQUO', true);
define('TT_ROOT', getcwd() . DIRECTORY_SEPARATOR);

require_once('mobiquoCommon.php');

MbqMain::init(); // frame init
MbqMain::input(); // handle input data
require_once(MBQ_PATH.'IncludeBeforeMbqAppEnv.php');
MbqMain::initAppEnv(); // application environment init
MbqMain::$oMbqConfig->calCfg(true);
@ ob_start();
require_once(MBQ_PATH . '/logger.php');
require_once(MBQ_FRAME_PATH . '/MbqBaseStatus.php');
class MbqStatus extends MbqBaseStatus
{

    public function GetLoggedUserName()
    {
        if(MbqMain::$oCurMbqEtUser != null)
        {
            return MbqMain::$oCurMbqEtUser->loginName->oriValue;
        }
        return 'anonymous';
    }
    protected function GetMobiquoFileSytemDir()
    {
        return TT_ROOT;
    }
    protected function GetMobiquoDir()
    {
        $settings = vB::getDatastore()->getValue('options');
        return isset($settings['tapatalk_directory']) ? $settings['tapatalk_directory'] : "";
    }
    protected function GetApiKey()
    {
        $settings = vB::getDatastore()->getValue('options');
        return isset($settings['tapatalk_api_key']) ? $settings['tapatalk_api_key'] : "";
    }
    protected function GetForumUrl()
    {
        $settings = vB::getDatastore()->getValue('options');
        return isset($settings['frontendurl']) ? $settings['frontendurl'] : "";
    }
    protected function GetPushSlug()
    {
        $oDb = vB::getDBAssertor()->getDBConnection();
        $results = $oDb->query_first(" SELECT * FROM " . TABLE_PREFIX . "tapatalk_status" );
        if ($results) {
            return unserialize($results['status_info']);
        }
        return 0;
    }

    protected function ResetPushSlug()
    {
        $oDb = vB::getDBAssertor()->getDBConnection();

        $results = $oDb->query_first(" SELECT count(update_time) as num FROM " . TABLE_PREFIX . "tapatalk_status" );
        if ($results['num'] == 1) {
            $results = $oDb->query_write("UPDATE " .TABLE_PREFIX. "tapatalk_status SET update_time = '0', status_info = ''" );
        } elseif ($results['num'] == 0) {
            $results = $oDb->query_write( "INSERT INTO ". TABLE_PREFIX . "tapatalk_status (status_info,create_time,update_time) VALUES ('','0','0') ");
        }
        return;
    }
    protected function FilePermissionOthers()
    {
        if(is_dir(TT_ROOT . '/../core/packages/tapatalk'))
        {
            $permissions = substr(sprintf('%o', fileperms(TT_ROOT . '/../core/packages/tapatalk')), -4);
            return array("result"=>1, "description"=>"<font style='color:green'>'core/packages/tapatalk' folder exists at forum root with permissions $permissions</font>");
        }
        else
        {
            return array("result"=>-1, "description"=>"<font style='color:red'>'core/packages/tapatalk' folder not exists at forum root so push notification will not work. Please check your plugin installation.</font>");
        }
    }
    protected function GetBYOInfo()
    {
        global $vbulletin;
        $app_banner_enable =  $vbulletin->options['tapatalk_smartbanner'];
        $google_indexing_enabled = $vbulletin->options['tapatalk_mobilegoogle'];
        $TT_expireTime = vB_Cache::instance(vB_Cache::CACHE_STD)->read('tapatalk_banner_expire');
        $TT_bannerControlData = vB_Cache::instance(vB_Cache::CACHE_STD)->read('tapatalk_banner_data');
        if (file_exists(MBQ_3RD_LIB_PATH .'/classTTConnection.php')){
             include_once(MBQ_3RD_LIB_PATH .'/classTTConnection.php');
        }
        $TT_connection = new classTTConnection();
        $TT_connection->calcSwitchOptions($TT_bannerControlData, $app_banner_enable, $google_indexing_enabled);
        $TT_bannerControlData['update'] = $TT_expireTime;
        $TT_bannerControlData['banner_enable'] = $app_banner_enable;
        $TT_bannerControlData['google_enable'] = $google_indexing_enabled;
        return $TT_bannerControlData;
    }

    protected function GetOtherPlugins()
    {
        global $vbulletin;
        $plugins = $vbulletin->db->query_read("
		SELECT *
		FROM " . TABLE_PREFIX . "product
        WHERE active=1
		ORDER BY title
	    ");
        $result = array();
        while ($plugin = $vbulletin->db->fetch_array($plugins))
        {
            $result[] = array('name'=>$plugin['title'], 'version'=>$plugin['version']);
        }
        return $result;
    }

}
$mbqStatus = new MbqStatus();

