<?php

global $vbulletin, $controller,$app;

if(isset($app))
{
    try{
        $routing = $app->getRouter();
        $controller = $routing->getController();
        if ($controller == 'ajax' || $controller == 'admin')
        {
            return;
        }
    }
    catch(Exception $ex)
    {

    }
}
$board_url = $vbulletin->options['bburl'];
$board_url = preg_replace('#/core$#', '', trim($board_url));
$app_forum_name = $vbulletin->options['bbtitle'] ? $vbulletin->options['bbtitle'] : '';
$tapatalk_dir = isset($vbulletin->options['tapatalk_directory']) ? $vbulletin->options['tapatalk_directory'] : 'mobiquo';
$api_key = $vbulletin->options['tapatalk_api_key'];
if($page['pagetemplateid']==1){
    $page_type = 'home';
}
else if($page['pagetemplateid']==2){
    $page_type = 'forum';
}
else if($page['pagetemplateid']==4){
    $page_type = 'topic';
}
else{
    $page_type = 'others';
}
$TT_AllowSmartbanner = true;

$tapatalk_banner_data = vB_Cache::instance(vB_Cache::CACHE_STD)->read('tapatalk_banner_data');

$TT_bannerControlData = !empty($tapatalk_banner_data) ? $tapatalk_banner_data : false;

$app_banner_enable =  $vbulletin->options['tapatalk_smartbanner'];
$google_indexing_enabled = $vbulletin->options['tapatalk_mobilegoogle'];
include_once('./'.$tapatalk_dir . '/mbqFrame/3rdLib/classTTConnection.php');
$TT_connection = new classTTConnection();
$TT_connection->calcSwitchOptions($TT_bannerControlData, $app_banner_enable, $google_indexing_enabled);

if(isset($TT_bannerControlData['byo_info']) && !empty($TT_bannerControlData['byo_info']))
{
    $app_rebranding_id = $TT_bannerControlData['byo_info']['app_rebranding_id'];
    $app_url_scheme = $TT_bannerControlData['byo_info']['app_url_scheme'];
    $app_icon_url = $TT_bannerControlData['byo_info']['app_icon_url'];
    $app_name = $TT_bannerControlData['byo_info']['app_name'];
    $app_alert_status = $TT_bannerControlData['byo_info']['app_alert_status'];
    $app_alert_message = $TT_bannerControlData['byo_info']['app_alert_message'];

    $app_android_id = $TT_bannerControlData['byo_info']['app_android_id'];
    $app_android_description = $TT_bannerControlData['byo_info']['app_android_description'];
    $app_banner_message_android = $TT_bannerControlData['byo_info']['app_banner_message_android'];
    $app_banner_message_android = preg_replace('/\r\n/','<br>',$app_banner_message_android);

    $app_ios_id = $TT_bannerControlData['byo_info']['app_ios_id'];
    $app_ios_description = $TT_bannerControlData['byo_info']['app_ios_description'];
    $app_banner_message_ios = $TT_bannerControlData['byo_info']['app_banner_message_ios'];
    $app_banner_message_ios = preg_replace('/\r\n/','<br>',$app_banner_message_ios);
}

// if in hide forums, not display the banner
$TT_hide_fids = $vbulletin->options['tapatalk_hide_forum'];
$TT_hide_array = unserialize($TT_hide_fids);

if (!empty($TT_hide_array))
{
    $TT_forumid = $routeData['channelid'];
    if (!empty($TT_forumid))
    {
        while($TT_forumid!=0){
            if(in_array($TT_forumid,$TT_hide_array))
                $TT_AllowSmartbanner =false;
            $nodefullcontent = vB_Api::instanceInternal('node')->getFullContentforNodes($TT_forumid);
            $TT_forumid = $nodefullcontent[0]['parentid'];
        }
    }
}
$app_banner_version_id = isset($TT_bannerControlData['banner_version']) ? $TT_bannerControlData['banner_version'] : 9;
$returndata = array();
$app_location = get_scheme_url($page,$routeData,$returndata);
if($page_type == 'topic'){
    $app_sharelink_location = $page_type;
    $app_sharelink_url = $app_location;
    $app_sharelink_ttforumid = isset($TT_bannerControlData['forum_id']) ? $TT_bannerControlData['forum_id'] : 0;
    $app_sharelink_tid = isset($returndata['tid']) ? $returndata['tid'] : 0;
}

try{
    if(isset($vbulletin->publicoptions['frontendurl'])){
        $smartBannerPath = $vbulletin->publicoptions['frontendurl'] . '/'.$tapatalk_dir . '/smartbanner/';
    } else {
        $smartBannerPath = './'.$tapatalk_dir . '/smartbanner/';
    }
}
catch(Exception $ex)
{
    $smartBannerPath = './'.$tapatalk_dir . '/smartbanner/';
}


if ($TT_AllowSmartbanner && file_exists('./'.$tapatalk_dir . '/smartbanner/head.inc.php'))
    include_once('./'.$tapatalk_dir . '/smartbanner/head.inc.php');

$headinclude = isset($app_head_include) ? $app_head_include : '';

echo($headinclude);


function get_scheme_url($pageinfo,$routeData,&$returndata)
{
    global $vbulletin;

    $baseUrl = $vbulletin->options['bburl'];
    $baseUrl = preg_replace('/https?:\/\//', '', $baseUrl);
    $location = 'index';
    $other_info = array();

    if($pageinfo['pagetemplateid']==1){                         //category page

    }
    else if($pageinfo['pagetemplateid']==2){                 //forum page
        $location = 'forum';
        $other_info[] = 'fid='.$routeData['channelid'];
        $perpage = $vbulletin->options['maxthreads'];
        $page = $routeData['pagenum'] > 0 ? $routeData['pagenum'] : 1;
    }
    else if($pageinfo['pagetemplateid']==4){                 //topic page
        $location = 'topic';
        $perpage = $vbulletin->options['maxposts'];
        $page = $routeData['pagenum'];
        $other_info[] = 'fid='.$routeData['channelid'];
        $other_info[] = 'tid='.$routeData['nodeid'];
        $returndata['tid'] = $routeData['nodeid'];
    }
    else if($pageinfo['pagetemplateid']==5){                 //search page
        $location = 'search';
    }
    else if($pageinfo['pagetemplateid']==10){               //online page
        $location = 'online';
    }
    else if($pageinfo['pagetemplateid']==11){                //profile page
        $location = 'profile';
        $other_info[] = 'uid='.$routeData['userid'];
    }
    else if($pageinfo['pagetemplateid']==16&&$routeData['subtemplate']=='privatemessage_view'){                //message page
        $location = 'message';
        $message = vB_Api::instanceInternal('content_privatemessage')->getContent($routeData['messageid']);
        $mid = array_keys($message[$routeData['messageid']]['recipients'])[0];
        $other_info[] = 'mid='.$mid;
    }

    $other_info_str = implode('&', $other_info);
    $scheme_url = $baseUrl. (!empty($vbulletin->userinfo['userid']) ? '?user_id='.$vbulletin->userinfo['userid'].'&' : '?') . 'location='.$location.(!empty($page) && !empty($perpage) ? "&page=$page&perpage=$perpage" : '').(!empty($other_info_str) ? '&'.$other_info_str : '');

    return $scheme_url;
}