<?php

define('MBQ_PUSH_BLOCK_TIME', 60);    /* push block time(minutes) */
require_once(dirname(__FILE__).'/../mbqFrame/basePush/TapatalkBasePush.php');   //this sentence only used for push feature of native plugin
require_once(dirname(__FILE__).'/../helper.php');   //this sentence only used for push feature of native plugin

/**
 * push class
 *
 * @since  2013-7-10
 * @author Wu ZeTao <578014287@qq.com>
 */
Class TapatalkPush extends TapatalkBasePush {

   //init
    public function __construct() {
        parent::__construct($this);
        $exttOptions = vB::getDatastore()->getValue('options');
        $this->oDb = vB::getDBAssertor()->getDBConnection();
        $oUser = (object) vB_Api::instance('user')->fetchCurrentUserinfo();
        if ($oUser->userid) {
            $this->oUser = $oUser;
        }
        $this->loadImActive();
        $this->loadPushStatus();
        $this->loadSupportedPushType();
        $this->siteUrl = $exttOptions['frontendurl'];
    }
    function get_push_slug()
    {
        $results = $this->oDb->query_first(" SELECT * FROM " . TABLE_PREFIX . "tapatalk_status" );
        if ($results) {
            return unserialize($results['status_info']);
        }
        return 0;
    }
    function set_push_slug($slug = null)
    {
        if (is_null($slug)) {
            $data = serialize($this->slugData);
        } else {
            $this->slugData = $slug;
            $data = serialize($slug);
        }
        $results = $this->oDb->query_first(" SELECT count(update_time) as num FROM " . TABLE_PREFIX . "tapatalk_status" );
        if ($results['num'] >= 1) {
            $results = $this->oDb->query_write("UPDATE " .TABLE_PREFIX. "tapatalk_status SET update_time = '".time()."', status_info = '".$data."'" );
        } elseif ($results['num'] == 0) {
            $time = time();
            $results = $this->oDb->query_write( "INSERT INTO ". TABLE_PREFIX . "tapatalk_status (status_info,create_time,update_time) VALUES ('$data','$time','$time') ");
        } else {
            return false;
        }
        return $results;
    }
    /**
     * load $this->supportedPushType
     */
    protected function loadSupportedPushType() {
        if (MbqMain::$customConfig['base']['push_type']) {
            $this->supportedPushType = explode(',', MbqMain::$customConfig['base']['push_type']);
        }
    }

    /**
     * load $this->imActive
     *
     * @return Boolean
     */
    protected function loadImActive() {
        if (isset($this->oUser) && $this->getActiveAppUserIds($this->oUser->userid)) {
            $this->imActive = true;
        } else {
            $this->imActive = false;
        }
    }

    /**
     * filter active user id from tapatalk_push_user table
     *
     * @param  Mixed  user id(integer) or user ids(array)
     * @return  Array  return empty array when get error,or return active user ids array
     */
    protected function getActiveAppUserIds($var) {
        if (!is_array($var)) {
            $var = array($var);
        } else {
            foreach ($var as $key => $value) {
                if (empty($value))
                    unset($var[$key]);
            }
        }
        if(empty($var))
            return array();
        //foreach ($var as &$v) {
            //$v = $this->oDb->quote($v);
        //}
        $inSql = implode (',', $var);
        $results = $this->oDb->query(" SELECT user_id FROM " . TABLE_PREFIX . "tapatalk_push_user WHERE user_id IN ($inSql)" );
        $ret = array();
        while ($result = $this->oDb->fetch_array($results)){
            $ret[] = $result['user_id'];
        }
        return $ret;
    }

    /**
     * load $this->pushStatus and $this->pushKey
     */
    protected function loadPushStatus() {
        $options = vB::getDatastore()->getValue('publicoptions');
        $options['tapatalk_activity'] = true;
        if ($options['tapatalk_api_key'] && $options['tapatalk_activity'] && (@ini_get('allow_url_fopen') || function_exists('curl_init'))) {
            if ($options['tapatalk_api_key']) {
                $this->pushKey = $options['tapatalk_api_key'];
            }
            if ($options['tapatalk_activity']) {
                $this->pushStatus = true;
                return;
            }
        }
        $this->pushStatus = false;
    }

    /**
     * judge db error
     *
     * @return  Boolean
     */
    protected function findDbError() {
        if (!$this->oDb) {
            $this->errMsg = 'Db error occured.';
            return true;
        }
        return false;
    }

    /**
     * save slug
     *
     * @param  Mixed $slug
     * @return Boolean
     */
    protected function saveSlug($slug = NULL) {
        if (is_null($slug)) {
            $data = json_encode($this->slugData);
        } else {
            $this->slugData = $slug;
            $data = json_encode($slug);
        }
        $results = $this->oDb->query_first(" SELECT count(update_time) as num FROM " . TABLE_PREFIX . "tapatalk_status" );
        if ($results['num'] == 1) {
            $results = $this->oDb->query_write("UPDATE " .TABLE_PREFIX. "tapatalk_status SET update_time = '".time()."', status_info = '".$data."'" );
        } elseif ($results['num'] == 0) {
            $time = time();
            $results = $this->oDb->query_write( "INSERT INTO ". TABLE_PREFIX . "tapatalk_status (status_info,create_time,update_time) VALUES ('$data','$time','$time') ");
        } else {
            return false;
        }
        return $results;
    }

    /**
     * load $this->slugData
     *
     * @return Boolean
     */
    protected function loadSlug() {
        $results = $this->oDb->query_first(" SELECT * FROM " . TABLE_PREFIX . "tapatalk_status" );
        if ($results) {
            $this->slugData = json_decode($results['status_info']);
        } else {
            $this->slugData = array();  //default is empty array
        }
        return true;
    }


    /**
     * record user info after login from app
     *
     * @return Boolean
     */
    protected function doAfterAppLogin($p) {
        $oUser = (object) vB_Api::instance('user')->fetchCurrentUserinfo();
        if ($oUser->userid && $this->pushStatus) {
            $results = $this->oDb->query_first("SELECT count(user_id) as num FROM " . TABLE_PREFIX . "tapatalk_push_user WHERE user_id='$oUser->userid'" );
            if ($results['num'] >= 1) {
                $results = $this->oDb->query_write("UPDATE " .TABLE_PREFIX. "tapatalk_push_user SET update_time = '".time()."' WHERE user_id = '$oUser->userid'" );
            } elseif ($results['num'] == 0) {
                $values = array($oUser->userid,time() ,time());
                $results = $this->oDb->query_write( "INSERT INTO ". TABLE_PREFIX . "tapatalk_push_user (user_id,create_time,update_time) VALUES  (" . implode(',', $values) . ")" );
            } else {
                return false;
            }
        }
        return false;
    }

    /**
     * thank push
     *
     * @param  Array  $p
     * @return Boolean
     */
    protected function doPushThank($p) {
        $push_data = array();
        if (defined('MBQ_IN_IT') && MBQ_IN_IT) {    //mobiquo
            if ($p['oMbqEtForumPost'] && $p['oMbqEtThank']) {
                $pushPack = array(
                    'userid'    => $p['oMbqEtForumPost']->postAuthorId->oriValue,
                    'type'      => 'thank',
                    'id'        => $p['oMbqEtForumPost']->topicId->oriValue,
                    'subid'     => $p['oMbqEtForumPost']->postId->oriValue,
                    'title'     => $p['oMbqEtForumPost']->postTitle->oriValue,
                    'author'    => $this->getPushName(),
                    'authorid' => $this->getPushUserId(),
                    'dateline'  => time()
                );
                $push_data[] = $pushPack;
                $this->push($push_data);
            }
        } else {    //native plugin
            if ($p['oKunenaForumMessage']) {
                $pushPack = array(
                    'userid'    => $p['oKunenaForumMessage']->userid,
                    'type'      => 'thank',
                    'id'        => $p['oKunenaForumMessage']->thread,
                    'subid'     => $p['oKunenaForumMessage']->id,
                    'title'     => $p['oKunenaForumMessage']->subject,
                    'author'    => $this->getPushName(),
                    'authorid' => $this->getPushUserId(),
                    'dateline'  => time()
                );
                $push_data[] = $pushPack;
                $this->push($push_data);
            }
        }
        return false;
    }

    /**
     * newtopic push(include some types push)
     *
     * @param  Array  $p
     * @return Boolean
     */
    public function doPushNewtopic($data) {
        // get user follow topic
        $userIds = array();
        $forumId = $data['subfid'];
        $follows = vB_Api::instanceInternal('follow')->getContentFollowers($forumId);
        if(!empty($follows['results'])) foreach ($follows['results'] as $follow){
            if($follow['userid'] != $this->oUser->userid) $userIds[$follow['username']] = $follow['userid'];
        }

        $push_data = array(
            'type'      => 'newtopic',
            'url'       => $this->siteUrl,
            'key'       => $this->pushKey,
            'id'        => $data['id'],
            'subid'     => $data['subid'],
            'subfid'    => $forumId,
            'title'     => $data['title'],
            'content'     => $data['content'],
            'sub_forum_name' => $data['sub_forum_name'],
            'author'    => $this->getPushName(),
            'authorid' => $this->getPushUserId(),
            'author_ua' => $this->getClienUserAgent(),
            'author_type' => $this->getPushUserType(),
            'from_app'  => $this->getIsFromApp(),
            'dateline'  => $data['dateline'],
        );

        $userIds = $this->doPushTagAndQuote($push_data, $userIds);
        if($userIds){
            $userIds = $this->getActiveAppUserIds($userIds);
            $push_data['userid'] = implode(',',$userIds);
            $push_data['push'] = 1;
        }
        else
        {
            $push_data['push'] = 0;
        }
        parent::do_push_request($push_data);
    }

    /**
     * reply push(include some types push)
     *
     * @param  Array  $p
     * @return Boolean
     */
    public function doPushReply($data) {
        // get user follow topic
        $userIds = array();
        $follows = vB_Api::instanceInternal('follow')->getContentFollowers($data['id']);
        if(!empty($follows['results'])) foreach ($follows['results'] as $follow){
            if($follow['userid'] != $this->oUser->userid) $userIds[$follow['username']] = $follow['userid'];
        }
        $push_data = array(
                'type'      => 'sub',
                'url'       => $this->siteUrl,
                'key'       => $this->pushKey,
                'id'        => $data['id'],
                'subid'     => $data['subid'],
                'subfid'    => $data['subfid'],
                'title'     => $data['title'],
                'content'     => $data['content'],
                'sub_forum_name' => $data['sub_forum_name'],
                'author'    => $this->getPushName(),
                'authorid' => $this->getPushUserId(),
                'author_ua' => $this->getClienUserAgent(),
                'author_type' => $this->getPushUserType(),
                'from_app'  => $this->getIsFromApp(),
                'dateline'  => $data['dateline'],
            );

        $userIds = $this->doPushTagAndQuote($push_data, $userIds);
        if($userIds){
            $userIds = $this->getActiveAppUserIds($userIds);
            $push_data['userid'] = implode(',',$userIds);
            $push_data['push'] = 1;
        }
        else
        {
            $push_data['push'] = 0;
        }
        parent::do_push_request($push_data);
    }


    public function doPushNewConversation($data){
        $push_data = array(
            'type'      => 'conv',
            'url'       => $this->siteUrl,
            'key'       => $this->pushKey,
            'id'        => $data['id'],
            'mid'     => $data['mid'],
            'title'     => $data['title'],
            'content'     => $data['content'],
            'author'    => $this->getPushName(),
            'authorid' => $this->getPushUserId(),
            'author_ua' => $this->getClienUserAgent(),
            'author_type' => $this->getPushUserType(),
            'from_app'  => $this->getIsFromApp(),
            'dateline'  => $data['dateline'],
        );
        $userIds = $this->getActiveAppUserIds($data['userid']);
        if($userIds){
            $push_data['userid'] = implode(',',$userIds);
            $push_data['push'] = 1;
            parent::do_push_request($push_data);
        }
    }

    public function doPushTagAndQuote($data,$userIds){
        $rawtext = $data['content'];
        $tagUsers = $this->getTagList($rawtext);
        $quotedUsers = $this->getQuotedList($rawtext, $tagUsers);

        foreach($userIds as $key => $v){
            $permission = vB::getUserContext($v)->getChannelPermission('forumpermissions', 'canviewthreads', $data['id']);
            if(!$permission){
                unset($userIds[$key]);
            }
        }


        $tagUserIds = array();
        if($tagUsers){
            foreach ($tagUsers as $userName) {
                if( $userName == $this->oUser->username) continue;
                if(isset($userIds[$userName]))
                    $tagUserIds[$userName] = $userIds[$userName];
                else{
                    $userName = vB_String::htmlSpecialCharsUni($userName);
                    $result = vB_Api::instanceInternal('user')->fetchByUsername($userName);
                    $tagUserIds[$userName] = $result['userid'];
                }

                $result = vB_Api::instanceInternal('user')->fetchByUsername($userName);
                $permission = vB::getUserContext($result['userid'])->getChannelPermission('forumpermissions', 'canviewthreads', $data['id']);
                if(!$permission){
                    unset($tagUserIds[$userName]);
                }

            }
            $tag_push_data = $data;
            $tag_push_data['type'] = 'tag';
            $tagUserIds = $this->getActiveAppUserIds($tagUserIds);
            if($tagUserIds)
            {
                $tag_push_data['userid'] = implode(',',$tagUserIds);
                $tag_push_data['push'] = 1;
                parent::do_push_request($tag_push_data);
            }
        }

        $quoteUserIds = array();
        if($quotedUsers){
            foreach ($quotedUsers as $userName) {
                if( $userName == $this->oUser->username) continue;
                if(isset($userIds[$userName]))
                    $quoteUserIds[$userName] = $userIds[$userName];
                else{
                    $userName = vB_String::htmlSpecialCharsUni($userName);
                    $result = vB_Api::instanceInternal('user')->fetchByUsername($userName);
                    $quoteUserIds[$userName] = $result['userid'];
                }

                $result = vB_Api::instanceInternal('user')->fetchByUsername($userName);
                $permission = vB::getUserContext($result['userid'])->getChannelPermission('forumpermissions', 'canviewthreads', $data['id']);
                if(!$permission){
                    unset($quoteUserIds[$userName]);
                }
            }
            $quote_push_data = $data;
            $quote_push_data['type'] = 'quote';
            $quoteUserIds = $this->getActiveAppUserIds($quoteUserIds);
            if($quoteUserIds)
            {
                $quote_push_data['userid'] = implode(',',$quoteUserIds);
                $quote_push_data['push'] = 1;
                parent::do_push_request($quote_push_data);
            }

        }

        foreach($userIds as $key => $v){
            $permission = vB::getUserContext($v)->getChannelPermission('forumpermissions', 'canviewthreads', $data['id']);
            if(!$permission){
                unset($userIds[$key]);
            }
        }


        $tagQuote = array_merge($tagUserIds, $quoteUserIds);
        return array_diff($userIds, $tagQuote);
    }

    public function doPushDelete($data){
        $push_data = array(
            'type'      => $data['type'],
            'url'       => $this->siteUrl,
            'key'       => $this->pushKey,
            'id'        => $data['id'],
            'from_app'  => $this->getIsFromApp(),
            'spamuids'  => $data['spamuids'],
            // 'hard'      => $data['hard'],
            'pushtime'  => time(),
            'userid'    => '',
        );
        parent::do_push_request($push_data);
    }

    public function getTagList($rawtext)
    {
        if ( defined('IN_MOBIQUO') && preg_match_all( '/(?<=^@|\s@)(#(.{1,50})#|\S{1,50}(?=[,\.;!\?]|\s|$))/U', $rawtext, $tags ) )
            return array_unique($tags[1]);
        elseif (preg_match_all('/<a class="b-bbcode-user[^"]+js-bbcode-user[^"]+"[^>]+>(.*?)<\/a>/si', $rawtext, $tags))
            return array_unique($tags[1]);

        return array();
    }

    public function getQuotedList($rawtext, $tagUsers)
    {
        // bypass verify if current user can read quoted threads temporarily
        if (preg_match_all('/\[quote=(.*?);n?(\d+)\]/si', $rawtext, $quotes))
        {
            if(!empty($tagUsers)){
                $onlyQuoteArr =  array_diff($quotes[1], $tagUsers);
                return array_unique($onlyQuoteArr);
            }
            else
                return array_unique($quotes[1]);
        }

        return array();
    }
    protected function doInternalPushThank($p){}

    protected function doInternalPushReply($p){}

    protected function doInternalPushReplyConversation($p){}

    protected function doInternalPushNewTopic($p){}

    protected function doInternalPushNewConversation($p){}

    protected function doInternalPushNewMessage($p){}

    protected function doInternalPushLike($p){
        try{
            $oMbqEtForumPost = $p['oMbqEtForumPost'];
            $push_data = array(
                'type'      => 'like',
                'url'       => $this->siteUrl,
                'key'       => $this->pushKey,
                'id'        => $oMbqEtForumPost->topicId->oriValue,
                'subid'     => $oMbqEtForumPost->postId->oriValue,
                'subfid'    => $oMbqEtForumPost->forumId->oriValue,
                'title'     => $oMbqEtForumPost->oMbqEtForumTopic->topicTitle->oriValue,
                'content'     =>$oMbqEtForumPost->postContent->tmlDisplayValue,
                'sub_forum_name' => $oMbqEtForumPost->oMbqEtForum->forumName->oriValue,
                'author'    => $this->getPushName(),
                'authorid' => $this->getPushUserId(),
                'author_ua' => $this->getClienUserAgent(),
                'author_type' => $this->getPushUserType(),
                'from_app'  => $this->getIsFromApp(),
                'dateline'  => time(),
            );
            $likedUserIds = $oMbqEtForumPost->postAuthorId->oriValue;
            $likedUserIds = $this->getActiveAppUserIds($likedUserIds);
            if($likedUserIds)
            {
                $push_data['userid'] = implode(',',$likedUserIds);
                $push_data['push'] = 1;
            }
            else
            {
                $push_data['push'] = 0;
            }
            parent::do_push_request($push_data);
        }
        catch(Exception $e){
        }
    }

    protected function doInternalPushNewSubscription($p){}
    protected function doInternalPushDeleteTopic($p){}
    protected function doInternalPushDeletePost($p){}

    public function getPushUserType()
    {
        return get_usertype_by_grpid($this->oUser->usergroupid);
    }
    public function getPushName(){
        return $this->oUser->username;
    }
   public function getPushUserId(){
       return $this->oUser->userid;
   }

}
