<?php

defined('MBQ_IN_IT') or exit;

MbqMain::$oClk->includeClass('MbqBaseWrEtUser');

/**
 * user write class
 */
Class MbqWrEtUser extends MbqBaseWrEtUser {

    public function __construct() {
    }

    /**
     * register user
     */
    public function registerUser($username, $password, $email, $verified, $custom_register_fields, $profile,  &$errors) {

        /* Create Member */
        $username = trim($username);
        $password = trim($password);
        $email    = trim($email);
        $postdata = array('username' => $username, 'email' => $email);

        if (isset($custom_register_fields['month']) AND isset($custom_register_fields['day']) AND !empty($custom_register_fields['year']))
        {
            $postdata['birthday'] = $custom_register_fields['year'] . '-' . str_pad($custom_register_fields['month'], 2, '0', STR_PAD_LEFT) . '-' . str_pad($custom_register_fields['day'], 2, '0', STR_PAD_LEFT);
        }

        if (!empty($custom_register_fields['guardian']))
        {
            $postdata['parentemail'] = $custom_register_fields['guardian'];
        }

        $vboptions = vB5_Template_Options::instance()->getOptions();
        $vboptions = $vboptions['options'];

        // Coppa cookie check
        $coppaage = vB5_Cookie::get('coppaage', vB5_Cookie::TYPE_STRING);
        if ($vboptions['usecoppa'] AND $vboptions['checkcoppa'])
        {
            if ($coppaage)
            {
                $dob = explode('-', $coppaage);
                $month = $dob[0];
                $day = $dob[1];
                $year = $dob[2];
                $postdata['birthday'] = $year . '-' . str_pad($month, 2, '0', STR_PAD_LEFT) . '-' . str_pad($day, 2, '0', STR_PAD_LEFT);
            }
            else
            {
                vB5_Cookie::set('coppaage', $_REQUEST['month'] . '-' . $_REQUEST['day'] . '-' . $_REQUEST['year'], 365, 0);
            }
        }

        //switch cbox type
        $oMbqRdEtUser = MbqMain::$oClk->newObj('MbqRdEtUser');
        $custom_register_fields_types = $oMbqRdEtUser->getCustomRegisterFields();
        if(is_array($custom_register_fields_types) && !empty($custom_register_fields_types))
        {
            foreach ($custom_register_fields_types as $field) {
                if($field['type'] == 'cbox')
                {
                    $key = $field['key'];
                    if(!empty($custom_register_fields[$key]) && is_array($custom_register_fields[$key]))
                        $custom_register_fields[$key] = array_keys($custom_register_fields[$key]);
                }
            }
        }

        //hvcheck input
        $vb_api_hv = vB_Api::instanceInternal('hv');
        $hvcheck = '';
        if ($vb_api_hv->fetchRequireHvcheck('register'))
        {
            $vb_api_hv->generateToken();
            $rudb = vB::getDBAssertor()->getDBConnection();
            $hv_result = $rudb->query_first(" SELECT *
                FROM " . TABLE_PREFIX . "humanverify WHERE viewed = 0
                ORDER BY dateline DESC LIMIT 1" );
            $hvcheck = array('input' => $hv_result['answer'], 'hash' => $hv_result['hash']);
        }

        $api = Api_InterfaceAbstract::instance();
        $data = array(
            'userid'   => 0,
            'password' => $password,
            'user'     => $postdata,
            array(),
            array(),
            'userfield' => (!empty($custom_register_fields) ? $custom_register_fields : false),
            array(),
            $hvcheck,
            array('registration' => true),
        );

        // add facebook data
        // if ($api->callApi('facebook', 'isFacebookEnabled') && $api->callApi('facebook', 'userIsLoggedIn'))
        // {
        //     $fbUserInfo = $api->callApi('facebook', 'getFbUserInfo');

        //     $data['user']['fbuserid'] = $fbUserInfo['id'];
        //     $data['user']['fbname'] = $fbUserInfo['name'];
        //     $data['user']['timezoneoffset'] = $fbUserInfo['timezone'];
        //     $data['user']['fbjoindate'] = time();

        //     $fb_profilefield_info = $this->getFacebookProfileinfo($fbUserInfo);

        //     if(!empty($fb_profilefield_info['birthday']) AND empty($data['user']['birthday']))
        //     {
        //         $data['user']['birthday'] = $fb_profilefield_info['birthday'];
        //     }

        //     if (empty($data['userfield']))
        //     {
        //         $data['userfield'] = array();
        //     }
        //     if ($vboptions['fb_userfield_biography'])
        //     {
        //         $data['userfield'] += array(
        //             $vboptions['fb_userfield_biography'] => $fb_profilefield_info['biography'],
        //         );
        //     }
        //     if ($vboptions['fb_userfield_location'])
        //     {
        //         $data['userfield'] += array(
        //             $vboptions['fb_userfield_location'] => $fb_profilefield_info['location'],
        //         );
        //     }
        //     if ($vboptions['fb_userfield_occupation'])
        //     {
        //         $data['userfield'] += array(
        //             $vboptions['fb_userfield_occupation'] => $fb_profilefield_info['occupation'],
        //         );
        //     }
        // }
        define('VB_UNITTEST',true,true); //this will bypass hummanverification
        $response = $api->callApi('user', 'save', $data);
        define('VB_UNITTEST',false); //this will bypass hummanverification

        if (!empty($response) AND (!is_array($response) OR !isset($response['errors'])))
        {
            $oMbqRdCommon = MbqMain::$oClk->newObj('MbqRdCommon');
            if($verified && $oMbqRdCommon->getAutoApprove() && ($vboptions['moderatenewmembers'] || $vboptions['verifyemail'])){
                $ud_userInfo = vB_User::fetchUserInfo($response);
                $ud_userdata = new vB_Datamanager_User(vB_DataManager_Constants::ERRTYPE_STANDARD);
                $ud_userdata->set_existing($ud_userInfo);
                $ud_userdata->set('usergroupid', 2);
                $ud_result = $ud_userdata->save();
            }

            /* Log them in */
            $loginInfo = $api->callApi('user', 'login', array($username, $password, '', '', ''));

            if (!isset($loginInfo['errors']) OR empty($loginInfo['errors']))
            {
                // browser session expiration
                vB5_Cookie::set('sessionhash', $loginInfo['sessionhash'], 0, true);
                vB5_Cookie::set('password', $loginInfo['password'], 0);
                vB5_Cookie::set('userid', $loginInfo['userid'], 0);

                $oMbqRdEtUser = MbqMain::$oClk->newObj('MbqRdEtUser');
                return $oMbqRdEtUser->initOMbqEtUser($response, array('case'=>'byUserId'));
            } else {
                MbqError::alert('', 'login fail!', '', MBQ_ERR_APP);
            }
        } else {
            if ( $response['errors'][0][0] == 'noregister' )
                MbqError::alert('', 'Sorry, registration has been disabled by the administrator.', '', MBQ_ERR_APP);
            else if ( $response['errors'][0][0] == 'usernametaken' )
                MbqError::alert('', 'Sorry, this username has been userd, please change and try again.', '', MBQ_ERR_APP);
            else if ( $response['errors'][0][0] == 'checkboxsize' )
                MbqError::alert('', 'You entered invalid custom fields!', '', MBQ_ERR_APP);
            else
                MbqError::alert('', 'Failed to register a new user.', '', MBQ_ERR_APP);
        }



    }

    //sys function
    // protected function getFacebookProfileinfo($fb_info)
    // {
    //     //our expected fields vs what facebook returns.  Null means we handle that specially.
    //     $profilefields = array (
    //         'biography'          => '',
    //         'location'           => '',
    //         'occupation'         => '',
    //         'birthday'           => '',
    //     );

    //     // occupation
    //     if (isset($fb_info['work']) AND isset($fb_info['work'][0]))
    //     {
    //         $history = $fb_info['work'][0];
    //         if (!empty($history->employer) AND !empty($history->employer->name))
    //         {
    //             $occupation[] = $history->employer->name;
    //         }

    //         if (!empty($history->position) AND !empty($history->position->name))
    //         {
    //                 $occupation[] = $history->employer->name;
    //         }

    //         if (!empty($history->employer) AND !empty($history->employer->description))
    //         {
    //                 $occupation[] = $history->employer->description;
    //         }

    //         $profilefields['occupation'] = implode(', ', $occupation);
    //     }

    //     // location
    //     if (isset($fb_info['location']))
    //     {
    //         if (!empty($fb_info['location']->name))
    //         {
    //                 $profilefields['location'] = $fb_info['location']->name;
    //         }
    //     }

    //     if (!empty($fb_info['bio']))
    //     {
    //         $profilefields['biography'] = $fb_info['bio'];
    //     }

    //     if (!empty($fb_info['birthday']))
    //     {
    //         //should always be MM/DD/YYYY per the DB docs
    //         $birthday = explode('/', $fb_info['birthday']);
    //         if(count($birthday) == 3)
    //         {
    //             $profilefields['birthday']['month'] = $birthday[0];
    //             $profilefields['birthday']['day'] = $birthday[1];
    //             $profilefields['birthday']['year'] = $birthday[2];
    //         }
    //     }

    //     return $profilefields;
    // }

    /**
     * m_ban_user
     */
    public function mBanUser($oMbqEtUser, $mode, $reason, $expires) {
        $bannedusergroups = vB_Api::instanceInternal('usergroup')->fetchBannedUsergroups();
        $banusergroupid = key($bannedusergroups);
        $user = vB_Api::instance('user')->banUsers(array($oMbqEtUser->userId->oriValue), $banusergroupid, $period = 'PERMANENT', $reason);
        if ($user === null || isset($user['errors'])) {
            MbqError::alert('', "User bans faild!", '', MBQ_ERR_APP);
        }
        if($mode == 2){
            $search_api = vB_Api::instanceInternal('search');
            $search_json = json_encode(array(
                    'authorid'		=> (array)$oMbqEtUser->userId->oriValue,
                    'ignore_cache'	=> true,
                    'exclude_type' => array(
                            'vBForum_Channel',
                            'vBForum_PrivateMessage',
                            'vBForum_Report',
                            'vBForum_Infraction',
                    )
            ));
            $result = $search_api->getSearchResult($search_json);
            $othernodeids = array();
            do {
                $othernodes = $search_api->getMoreNodes($result['resultId']);
                if ($othernodeids == array_values($othernodes['nodeIds'])) {
                    break;
                }
                $othernodeids = array_values($othernodes['nodeIds']);
                if (!empty($othernodeids)) {
                    vB_Api::instance('node')->deleteNodes($othernodeids, true, $reasonText, true);
                }
            } while (!empty($othernodeids));
        }
        return true;
    }

    /**
     * m_mark_as_spam
     */
    public function mMarkAsSpam($oMbqEtUser) {
        $userinfo = $oMbqEtUser->mbqBind['userRecord'];
        $stopForumSpam = vB_StopForumSpam::instance();
        $stopForumSpam->markAsSpam($userinfo['username'], $userinfo['ipaddress'], '' , $userinfo['email']);
    }

    /**
     * update password
     */
    public function updatePassword($oldPassword, $newPassword) {

        $context = vB::getUserContext();
        $userid = $context->fetchUserId();

        if (!$userid)
        {
            MbqError::alert('', 'You have not logged in!', '', MBQ_ERR_APP);
        }

        if ( !empty($newPassword) && !empty($oldPassword) ){
            $loginlib = vB_Library::instance('login');

            $userinfo = vB_User::fetchUserInfo($userid);
            $login = array_intersect_key($userinfo, array_flip(array('userid', 'token', 'scheme')));
            $auth = $loginlib->verifyPasswordFromInfo($login, array(array('password' => $oldPassword, 'encoding' => 'text')));

            if (!$auth['auth'])
            {
                MbqError::alert('', 'old password is wrong!', '', MBQ_ERR_APP);
            }

            $userdata = new vB_Datamanager_User(vB_DataManager_Constants::ERRTYPE_ARRAY_UNPROCESSED);
            $userdata->set_existing($userinfo);

            $loginlib->setPassword($userinfo['userid'], $newPassword,
                    array('passwordhistorylength' => $context->getLimit('passwordhistory'))
                );
            $userdata->set('secret', vB_Library::instance('user')->generateUserSecret());

            if (!$userdata->has_errors(false) && $userdata->save())
            {
                // clear user info cached
                vB_Library::instance('user')->clearUserInfo(array($userid));
                vB_Cache::instance(vB_Cache::CACHE_FAST)->event('userChg_' . $userid);
                vB_Cache::instance(vB_Cache::CACHE_LARGE)->event('userChg_' . $userid);

                return true;
            } else {
                MbqError::alert('', 'Update password failed!', '', MBQ_ERR_APP);
            }
        } else {
            MbqError::alert('', 'Please check your input!', '', MBQ_ERR_APP);
        }
    }

    /**
     * update email
     */
    public function updateEmail($password, $email, &$resultMessage) {

        $context = vB::getUserContext();
        $userid = $context->fetchUserId();

        if (!$userid)
        {
            MbqError::alert('', 'You have not logged in!', '', MBQ_ERR_APP);
        }

        if ( !empty($password) && !empty($email) ){
            $loginlib = vB_Library::instance('login');

            $userinfo = vB_User::fetchUserInfo($userid);
            $login = array_intersect_key($userinfo, array_flip(array('userid', 'token', 'scheme')));
            $auth = $loginlib->verifyPasswordFromInfo($login, array(array('password' => $password, 'encoding' => 'text')));

            if (!$auth['auth'])
            {
                MbqError::alert('', 'password is wrong!', '', MBQ_ERR_APP);
            }

            $userdata = new vB_Datamanager_User(vB_DataManager_Constants::ERRTYPE_ARRAY_UNPROCESSED);
            $userdata->set_existing($userinfo);
            $userdata->set('email', $email);

            if (!$userdata->has_errors(false) && $userdata->save())
            {
                $resultMessage = 'Update email successed!';
                // clear user info cached
                vB_Library::instance('user')->clearUserInfo(array($userid));
                vB_Cache::instance(vB_Cache::CACHE_FAST)->event('userChg_' . $userid);
                vB_Cache::instance(vB_Cache::CACHE_LARGE)->event('userChg_' . $userid);

                return true;
            } else {
                MbqError::alert('', 'Update email failed!', '', MBQ_ERR_APP);
            }
        } else {
            MbqError::alert('', 'Please check your input!', '', MBQ_ERR_APP);
        }
    }

    /**
     * update password directly
     */
    public function updatePasswordDirectly($oMbqEtUser, $newPassword) {
        $context = vB::getUserContext();
        $userid = $oMbqEtUser->userId->oriValue;

        if (!$userid)
        {
            MbqError::alert('', 'You have not logged in!', '', MBQ_ERR_APP);
        }

        if ( !empty($newPassword) ){
            $loginlib = vB_Library::instance('login');

            $userinfo = vB_User::fetchUserInfo($userid);
            $login = array_intersect_key($userinfo, array_flip(array('userid', 'token', 'scheme')));

            $userdata = new vB_Datamanager_User(vB_DataManager_Constants::ERRTYPE_ARRAY_UNPROCESSED);
            $userdata->set_existing($userinfo);

            $loginlib->setPassword($userinfo['userid'], $newPassword,
                    array('passwordhistorylength' => $context->getLimit('passwordhistory'))
                );
            $userdata->set('secret', vB_Library::instance('user')->generateUserSecret());

            if (!$userdata->has_errors(false) && $userdata->save())
            {
                // clear user info cached
                vB_Library::instance('user')->clearUserInfo(array($userid));
                vB_Cache::instance(vB_Cache::CACHE_FAST)->event('userChg_' . $userid);
                vB_Cache::instance(vB_Cache::CACHE_LARGE)->event('userChg_' . $userid);

                return true;
            } else {
                MbqError::alert('', 'Update password failed!', '', MBQ_ERR_APP);
            }
        } else {
            MbqError::alert('', 'Please check your input!', '', MBQ_ERR_APP);
        }
    }
    /**
     * ignoreUser
     */
    public function ignoreUser($oMbqEtUser, $mode) {
        $userIdToIgnore = $oMbqEtUser->userId->oriValue;
        $context = vB::getUserContext();
        $userid = $context->fetchUserId();
        $assertor = vB::getDbAssertor();
        if($mode == 0) //ignore user
        {

            //delete the existing ignored users
            $assertor->assertQuery('userlist', array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_DELETE,
                vB_dB_Query::CONDITIONS_KEY => array(
                    array('field' => 'userid', 'value' => $userid, 'operator' => vB_dB_Query::OPERATOR_EQ),
                    array('field' => 'relationid', 'value' => $userIdToIgnore, 'operator' => vB_dB_Query::OPERATOR_EQ),
                    array('field' => 'type', 'value' => 'ignore', 'operator' => vB_dB_Query::OPERATOR_EQ),
                    array('field' => 'friend', 'value' => 'denied', 'operator' => vB_dB_Query::OPERATOR_EQ)
                )
            ));

        }
        else
        {
            $existing = $assertor->getRow('userlist', array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_SELECT,
              'userid' => $userid,
              'relationid' => $userIdToIgnore
          ));

            // update the record
            if ($existing AND !empty($existing) AND empty($existing['errors']))
            {
                $queryData = array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_UPDATE,
                    vB_dB_Query::CONDITIONS_KEY => array('userid' => $userid, 'relationid' => $userIdToIgnore),
                    'type' => 'ignore',
                    'friend' => 'denied'
                );
            }
            else
            {
                $queryData = array(vB_dB_Query::TYPE_KEY => vB_dB_Query::QUERY_INSERT,
                    'userid' => $userid,
                    'relationid' => $userIdToIgnore,
                    'type' => 'ignore',
                    'friend' => 'denied'
                );
            }
            $assertor->assertQuery('userlist', $queryData);
        }
        return true;
    }
    public function uploadAvatar()
    {
        global $vbulletin, $userinfo;

        if (!$vbulletin->options['avatarenabled'])
        {
            return_fault(fetch_error('avatardisabled'));
        }
	    $apiobj = vB_Api::instanceInternal('profile');

        $file = $vbulletin->input->clean_gpc('f', 'upload', vB_Cleaner::TYPE_FILE);
        $apiobj->upload($file);

        return true;
    }
}

